<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Dukcapil extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dukcapils', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 255)->nullable();
            $table->string('nik', 255)->nullable();
            $table->string('no_kk', 255)->nullable();
            $table->string('nama_lengkap', 255)->nullable();
            $table->string('jenis_kelamin')->nullable();
            $table->string('tempat_lahir', 255)->nullable();
            $table->date('tanggal_lahir', 255)->nullable();
            $table->string('golongan_darah', 255)->nullable();
            $table->integer('id_agama')->nullable();
            $table->string('status_perkawinan', 255)->nullable();
            $table->string('status_hub_keluarga', 255)->nullable();
            $table->string('cacat_fisik_mental', 255)->nullable();
            $table->string('pendidikan_terakhir', 255)->nullable();
            $table->string('jenis_pekerjaan', 255)->nullable();
            $table->string('nik_ibu', 255)->nullable();
            $table->string('nama_ibu', 255)->nullable();
            $table->string('nik_ayah', 255)->nullable();
            $table->string('nama_ayah', 255)->nullable();
            $table->text('alamat_sebelumnya')->nullable();
            $table->text('alamat_sekarang')->nullable();
            $table->string('kepemilikan_akta_lahir',255)->nullable();
            $table->string('nomor_akta_lahir',255)->nullable();
            $table->string('kepemilikan_akta_kawin',255)->nullable();
            $table->string('nomor_akta_kawin',255)->nullable();
            $table->date('tanggal_perkawinan')->nullable();
            $table->string('kepemilikan_akta_cerai',255)->nullable();
            $table->string('nomor_akta_cerai',255)->nullable();
            $table->date('tanggal_cerai')->nullable();
            $table->string('sidik_jari', 255)->nullable();
            $table->string('iris_mata', 255)->nullable();
            $table->string('tanda_tangan', 255)->nullable();
            $table->string('elemen_data_lainnya', 255)->nullable();
            $table->string('data_agregat', 255)->nullable();
            $table->string('longitude', 255)->nullable();
            $table->string('latitude', 255)->nullable();
            $table->string('foto', 255)->nullable();
            $table->integer('id_provinsi')->nullable();
            $table->integer('id_kabupaten')->nullable();
            $table->integer('id_kecamatan')->nullable();
            $table->integer('id_kelurahan')->nullable();
            $table->integer('id_user')->nullable();
            $table->timestamps();
        });

        Schema::create('agamas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
