<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Hotel extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->text('alamat')->nullable();
            $table->string('latitude', 255)->nullable();
            $table->string('longitude', 255)->nullable();
            $table->double('persen_tax')->nullable();
            $table->timestamps();
        });

        Schema::create('kategori_fasilitas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('fasilitas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_kategori_fasilitas');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('features', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('hotel_fasilitas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_fasilitas');
            $table->integer('id_hotel');
            $table->timestamps();
        });

        Schema::create('hotel_ratings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_hotel');
            $table->text('review')->nullable();
            $table->integer('rating')->nullable();
            $table->integer('id_user')->nullable();
            $table->timestamps();
        });

        Schema::create('hotel_fotos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_hotel');
            $table->string('nama', 255)->nullable();
            $table->string('foto', 255)->nullable();
            $table->text('detail')->nullable();
            $table->timestamps();
        });

        Schema::create('rooms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_hotel');
            $table->string('nama', 255)->nullable();
            $table->text('about')->nullable();
            $table->double('harga')->nullable();
            $table->double('sqm')->nullable();
            $table->integer('jumlah_tamu')->nullable();
            $table->integer('total_available')->nullable();
            $table->boolean('is_refundable')->nullable();
            $table->boolean('is_reschedulable')->nullable();
            $table->timestamps();
        });

        Schema::create('room_beds', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_room');
            $table->integer('id_tipe_bed');
            $table->integer('total');
            $table->timestamps();
        });

        Schema::create('tipe_beds', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('room_features', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_room');
            $table->integer('id_feature');
            $table->timestamps();
        });

        Schema::create('room_fasilitas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_room');
            $table->integer('id_fasilitas');
            $table->timestamps();
        });

        Schema::create('room_fasilitas_kamar_mandis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_room');
            $table->integer('id_fasilitas');
            $table->timestamps();
        });

        Schema::create('room_fotos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_room');
            $table->string('nama', 255);
            $table->string('foto', 255);
            $table->text('detail')->nullable();
            $table->timestamps();
        });

        Schema::create('bookings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_user');
            $table->string('nama', 255);
            $table->string('no_telp');
            $table->string('email');
            $table->datetime('check_in');
            $table->datetime('check_out');
            $table->integer('id_hotel');
            $table->integer('id_room');
            $table->double('harga_room');
            $table->double('tax');
            $table->double('total_harga');
            $table->string('status');
            $table->boolean('is_tamu');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
