"use strict";

// DropzoneJS
if (window.Dropzone) {
  Dropzone.autoDiscover = false
}

var dropzone = new Dropzone("#mydropzone", {
  url: GLOBAL_URL + "/admin/hotel/simpan_gambar",
  maxFilesize: 20, // 2 MB
  acceptedFiles: ".jpeg,.jpg,.png", // Allowed extensions
  // success: function(file, response){ // Dropzone upload response

  //     var jsonObj = JSON.parse(response);

  //     if(jsonObj.status == 0){
  //           alert(jsonObj.msg);
  //     }
  // },
  // autoProcessQueue: false,
  method: "post",
  paramName: "file",
  clickable: true,
  autoQueue: true,
  addRemoveLinks: true,
});

var minSteps = 6,
  maxSteps = 60,
  timeBetweenSteps = 100,
  bytesPerStep = 100000;

dropzone.uploadFiles = function(files) {
  var self = this;

  for (var i = 0; i < files.length; i++) {

    var file = files[i];
    var totalSteps = Math.round(Math.min(maxSteps, Math.max(minSteps, file.size / bytesPerStep)));

    for (var step = 0; step < totalSteps; step++) {
      var duration = timeBetweenSteps * (step + 1);
      setTimeout(function(file, totalSteps, step) {
        return function() {
          file.upload = {
            progress: 100 * (step + 1) / totalSteps,
            total: file.size,
            bytesSent: (step + 1) * file.size / totalSteps
          };

          self.emit('uploadprogress', file, file.upload.progress, file.upload.bytesSent);
          
          if (file.upload.progress == 100) {
            file.status = Dropzone.SUCCESS;
            self.emit("success", file, 'success', null);
            self.emit("complete", file);
            self.processQueue();
            console.log("success");
          }
        };
      }(file, totalSteps, step), duration);
    }
  }
}

