<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>{{ config('app.name', 'Laravel') }}</title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="{{ asset('assets/css/app.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-social/bootstrap-social.css')}}">
  <!-- Template CSS -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/css/components.css')}}">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="{{ asset('assets/css/custom.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')}}">
  <link rel='shortcut icon' type='image/x-icon' href="{{ asset('assets/img/favicon.ico')}} " />
  <style>
    .form-group{
        margin: 5px !important;
    }
  </style>
</head>

<body>
<div class="loader"></div>
<div id="app">
    <section class="section">
      <div class="container mt-5">
        <div class="row">
            <div class="col-12 col-sm-10 offset-sm-1 col-md-8 offset-md-2 col-lg-8 offset-lg-2 col-xl-6 offset-xl-3">
                <div class="login-brand">
                {{ config('app.name', 'Laravel') }}
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h4>Selamat Datang</h4>
                    </div>
                    <div class="card-body">
                        @if(count($errors) > 0)
                            @foreach( $errors->all() as $message )
                            <div class="alert alert-danger display-hide">
                            <button class="close" data-close="alert"></button>
                            <span>{{ $message }}</span>
                            </div>
                            @endforeach
                        @endif
                        @if(Session::has('pesan'))
                        <div class="alert alert-danger display-hide">
                            <button class="close" data-close="alert"></button>
                            <span>{{ Session::get('pesan') }}</span>
                        </div>
                        @endif
                        @if(Session::has('pesan_sukses'))
                        <div class="alert alert-success display-hide">
                            <button class="close" data-close="alert"></button>
                            <span>{{ Session::get('pesan_sukses') }}</span>
                        </div>
                        @endif
                        <form method="POST" action="{{ route('login') }}" class="needs-validation" novalidate="">
                        @csrf
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                        <i class="fas fa-envelope"></i>
                                        </div>
                                    </div>
                                    <input id="email" type="email" placeholder="Email" class="form-control" name="email" tabindex="1" required autofocus>
                                    <div class="invalid-feedback">
                                    Please fill in your email
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                        <i class="fas fa-wrench"></i>
                                        </div>
                                    </div>
                                    <input id="password" type="password" placeholder="Password" class="form-control" name="password" tabindex="2" required>
                                    <div class="invalid-feedback">
                                    please fill in your password
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="form-group">
                                {!! captcha_img() !!}

                                <div class="input-group" style="margin-top: 5px">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                        <i class="fas fa-wrench"></i>
                                        </div>
                                    </div>
                                    <input id="captcha" type="text" placeholder="Captcha" class="form-control" name="captcha" required>
                                    <div class="invalid-feedback">
                                    please fill in your captcha
                                    </div>
                                </div>
                            </div> -->
                            <div class="form-group text-center">
                                <button type="submit" class="btn btn-icon icon-left btn-primary btn-block"  style="margin-top: 15px">
                                <i class="fas fa-sign-in-alt"></i>
                                MASUK
                                </button>
                            </div>
                            <div class="form-group">
                                <div class="row text-right">
                                    <div class="col-md-12 text-muted">
                                        Tidak punya akun ? <a href="javascript:;" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('DAFTAR')">DAFTAR</a>
                                    </div>
                                </div>
                            </div>
                            <!-- <hr>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-green btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('DAFTAR')">DAFTAR</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-orange btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('PERMISI')" title="Permohonan Menjadi Warga Kota Bekasi">PERMISI</button>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-grey btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('HALO PAMOR')">HALO PAMOR</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-black btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('ANDUK BANG BEK')" title="Pelayanan Kependudukan Bagi Yang Berkebutuhan Khusus">ANDUK BANG BEK</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-purple btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('DUDUK MESRA')" title="Butuh Pengaduan DISDUKCAPIL Melayani Masyarakat">DUDUK MESRA </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-pink btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('SITI BAWA LUDO')" title="Sistem Terintegrasi Bagi Warga Luar Domisili">SITI BAWA LUDO </button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-blue btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('MOTO KTP')" title="Permohonan Ganti Foto KTP-EL">MOTO KTP </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-red btn-block" data-toggle="modal" data-target="#exampleModal" onclick="GetModalContent('SIP ORA')" title="Sistem Pelayanan Orang Asing">SIP ORA </button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-yellow btn-block">PAMOR SAPA WARGA </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-icon icon-left bg-brown btn-block">SILAMPID</button>
                                    </div>
                                </div>
                            </div> -->

                        </form>
                    </div>
                </div>
                <div class="simple-footer">
                Copyright &copy; 2025
                </div>
            </div>
        </div>
      </div>
    </section>
</div>
<div class="modal fade" id="exampleModal" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modalContent">

            </div>
        </div>
    </div>
</div>
  <!-- General JS Scripts -->
  <script src="{{ asset('assets/js/app.min.js')}}"></script>
  <script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
  <script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->
  <script src="{{ asset('assets/js/scripts.js')}}"></script>
  <!-- Custom JS File -->
  <script src="{{ asset('assets/js/custom.js')}}"></script>

  <script>
    function GetModalContent(type)
    {
        $("#modalContent").empty();
        $("#formModal").text(type);
        $.get("{{ url('get-modal-content') }}/" + type, function(result){
            $("#modalContent").html(result);
        });
    }


  </script>
</body>

</html>
