
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>SAPATRI</title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="assets/css/app.min.css">
  <link rel="stylesheet" href="assets/bundles/jquery-selectric/selectric.css">
  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style.css">
  <link rel="stylesheet" href="assets/css/components.css">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="assets/css/custom.css">
  <link rel='shortcut icon' type='image/x-icon' href='assets/img/favicon.ico' />
  <link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <section class="section">
      <div class="container mt-5">
        <div class="row">
          <div class="col-12 col-sm-10 offset-sm-1 col-md-8 offset-md-2 col-lg-8 offset-lg-2 col-xl-8 offset-xl-2">
            <div class="card card-primary">
              <div class="card-header">
                <h4>DAFTAR</h4>
              </div>
              <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form method="POST" enctype="multipart/form-data">
                    @csrf
                  <div class="row">
                    {{-- <div class="form-group col-6">
                      <label for="nik">NIK</label>
                      <input id="nik" type="text" class="form-control" name="nik" required>
                    </div> --}}
                    <div class="form-group col-12">
                        <label for="name">Nama Lengkap</label>
                        <input id="name" type="text" class="form-control" name="name" autofocus required>
                      </div>
                  </div>

                  {{-- <div class="row">
                    <div class="form-group col-6">
                      <label for="tanggal_lahir">Tanggal Lahir</label>
                      <input id="tanggal_lahir" type="text" class="form-control datepicker" name="tanggal_lahir" readonly required>
                    </div>
                    <div class="form-group col-6">
                        <label for="jenis_kelamin">Jenis Kelamin</label>
                        <select name="jenis_kelamin" id="jenis_kelamin" class="form-control" required>
                            <option value="">-- Pilih Jenis Kelamin --</option>
                            <option value="Laki-Laki">Laki-Laki</option>
                            <option value="Perempuan">Perempuan</option>
                        </select>
                      </div>
                  </div> --}}

                  {{-- <div class="row">
                    <div class="form-group col-6">
                      <label for="id_provinsi">Provinsi</label>
                      <select name="id_provinsi" id="id_provinsi" class="form-control" onchange="getKabKota()" required>
                        <option value="">-- Pilih Provinsi--</option>
                        @foreach ($provinsi as $item)
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="id_kabupaten">Kabupaten/Kota</label>
                        <select name="id_kabupaten" id="id_kabupaten" class="form-control" required>
                            <option value="">-- Pilih Kabupaten/Kota--</option>
                        </select>
                      </div>
                  </div> --}}

                  {{-- <div class="form-group">
                        <label for="Alamat">Alamat</label>
                        <textarea name="alamat" id="alamat" class="form-control" required></textarea>
                  </div>

                  <div class="row">
                    <div class="form-group col-6">
                        <label for="no_telp">No Telp</label>
                        <input id="no_telp" type="text" class="form-control" name="no_telp" required>
                    </div>
                    <div class="form-group col-6">
                        <label for="file_pendukung">File Pendukung (KTP/SIM)</label>
                        <input type="file" name="file_pendukung" id="file_pendukung" class="form-control" required>
                    </div>
                  </div> --}}

                  <div class="form-group">
                    <label for="email">Email</label>
                    <input id="email" type="email" class="form-control" name="email" required>
                    <div class="invalid-feedback">
                    </div>
                  </div>
                  <div class="row">
                    <div class="form-group col-6">
                      <label for="password" class="d-block">Password</label>
                      <input id="password" type="password" class="form-control pwstrength" data-indicator="pwindicator" name="password" required>
                      <div id="pwindicator" class="pwindicator">
                        <div class="bar"></div>
                        <div class="label"></div>
                      </div>
                    </div>
                    <div class="form-group col-6">
                      <label for="password2" class="d-block">Password Confirmation</label>
                      <input id="password2" type="password" class="form-control" name="password_confirmation" required>
                    </div>
                  </div>
                  {{-- <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" name="agree" class="custom-control-input" id="agree">
                      <label class="custom-control-label" for="agree">I agree with the terms and conditions</label>
                    </div>
                  </div> --}}
                  <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-lg btn-block">
                      Register
                    </button>
                  </div>
                </form>
              </div>
              <div class="mb-4 text-muted text-center">
                Sudah Daftar ? <a href="{{ url('login') }}">Login</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <!-- General JS Scripts -->
  <script src="assets/js/app.min.js"></script>
  <!-- JS Libraies -->
  <script src="assets/bundles/jquery-pwstrength/jquery.pwstrength.min.js"></script>
  <script src="assets/bundles/jquery-selectric/jquery.selectric.min.js"></script>
  <!-- Page Specific JS File -->
  <script src="assets/js/page/auth-register.js"></script>
  <!-- Template JS File -->
  <script src="assets/js/scripts.js"></script>
  <!-- Custom JS File -->
  <script src="assets/js/custom.js"></script>
  <script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
  <script>
        $('.datepicker').daterangepicker({
            locale: { format: 'YYYY-MM-DD' },
            singleDatePicker: true,
        });
      function getKabKota()
      {
            var id_provinsi = $("#id_provinsi").val();
            $("#id_kabupaten").empty();

            var option = "";
            $.get("{{ url('get-kab-kota') }}/" + id_provinsi, function(result){

                $.each(result, function(i,l){

                    option += '<option value='+ l.id + '>'+l.name+'</option>';

                });

                $("#id_kabupaten").html(option);

            });
      }
  </script>
</body>

</html>
