@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Dukcapil</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="{{ url('/dukcapil') }}">Dukcapil</a></div>
      <div class="breadcrumb-item active"><a href="#">Tambah</a></div>
    </div>
</div>
<form method="POST" action="{{ url('dukcapil/simpan') }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="id" value="{{ $dukcapil->id }}">
    <div class="card card-primary">
        <div class="card-header">
            <h4>Tambah Data</h4>
        </div>
        <div class="card-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>NIK</label>
                        <input type="text" name="nik" class="form-control" value="{{ $dukcapil->nik }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>No KK</label>
                        <input type="text" name="no_kk" class="form-control" value="{{ $dukcapil->no_kk }}" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Nama Lengkap</label>
                        <input type="text" name="nama_lengkap" class="form-control" value="{{ $dukcapil->nama_lengkap }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            <option value="Laki-Laki" {{ ($dukcapil->jenis_kelamin == "Laki-Laki" ? "selected" : "")}}>Laki-Laki</option>
                            <option value="Perempuan" {{ ($dukcapil->jenis_kelamin == "Perempuan" ? "selected" : "")}}>Perempuan</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Tempat Lahir</label>
                        <input type="text" name="tempat_lahir" class="form-control" value="{{ $dukcapil->tempat_lahir }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control" value="{{ $dukcapil->tanggal_lahir }}" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Agama</label>
                        <select name="id_agama" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach($agama as $val)
                            <option value="{{ $val->id }}" {{ ($dukcapil->id_agama == $val->id ? "selected" : "")}}>{{ $val->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Golongan Darah</label>
                        <select name="golongan_darah" class="form-control">
                            <option value="">-- Silakan Pilih --</option>
                            <option value="A" {{ ($dukcapil->golongan_darah == "A" ? "selected" : "")}}>A</option>
                            <option value="B" {{ ($dukcapil->golongan_darah == "B" ? "selected" : "")}}>B</option>
                            <option value="AB" {{ ($dukcapil->golongan_darah == "AB" ? "selected" : "")}}>AB</option>
                            <option value="O" {{ ($dukcapil->golongan_darah == "O" ? "selected" : "")}}>O</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Alamat Sekarang</label>
                        <textarea name="alamat_sekarang" class="form-control" required>{{$dukcapil->alamat_sekarang}}</textarea>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Provinsi</label>
                        <select name="id_provinsi" id="id_provinsi" class="form-control select2" required>
                            @if($provinsi == null)
                            <option value="">-- Silakan Pilih --</option>
                            @else
                            <option value="{{ $provinsi->id }}">{{$provinsi->name}}</option>
                            @endif
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Kabupaten/Kota</label>
                        <select name="id_kabupaten" id="id_kabupaten" class="form-control select2" required>
                            @if($kabupaten == null)
                            <option value="">-- Silakan Pilih --</option>
                            @else
                            <option value="{{ $kabupaten->id }}">{{$kabupaten->name}}</option>
                            @endif
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Kecamatan</label>
                        <select name="id_kecamatan" id="id_kecamatan" class="form-control select2" required>
                            @if($kecamatan == null)
                            <option value="">-- Silakan Pilih --</option>
                            @else
                            <option value="{{ $kecamatan->id }}">{{$kecamatan->name}}</option>
                            @endif
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Kelurahan</label>
                        <select name="id_kelurahan" id="id_kelurahan" class="form-control select2" required>
                            @if($kelurahan == null)
                            <option value="">-- Silakan Pilih --</option>
                            @else
                            <option value="{{ $kelurahan->id }}">{{$kelurahan->name}}</option>
                            @endif
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Alamat Sebelumnya</label>
                        <textarea name="alamat_sebelumnya" class="form-control">{{$dukcapil->alamat_sebelumnya}}</textarea>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Status Perkawinan</label>
                        <select name="status_perkawinan" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            <option value="Lajang" {{ ($dukcapil->status_perkawinan == "Lajang" ? "selected" : "") }}>Lajang</option>
                            <option value="Kawin" {{ ($dukcapil->status_perkawinan == "Kawin" ? "selected" : "") }}>Kawin</option>
                            <option value="Duda/Janda" {{ ($dukcapil->status_perkawinan == "Duda/Janda" ? "selected" : "") }}>Duda/Janda</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Tanggal Perkawinan</label>
                        <input type="date" name="tanggal_perkawinan" value="{{$dukcapil->tanggal_perkawinan}}" class="form-control">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Status Hubungan Keluarga</label>
                        <input type="text" name="status_hub_keluarga" class="form-control" value="{{ $dukcapil->status_hub_keluarga }}">
                    </div>
                    <div class="col-md-6">
                        <label>Cacat Fisik/Mental</label>
                        <input type="text" name="cacat_fisik_mental" class="form-control" value="{{ $dukcapil->cacat_fisik_mental }}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Pendidikan Terakhir</label>
                        <select name="id_pendidikan_terakhir" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach($pendidikan_terakhir as $val)
                            <option value="{{ $val->id }}" {{($dukcapil->id_pendidikan_terakhir == $val->id ? "selected" : "")}}>{{ $val->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Jenis Pekerjaan</label>
                        <select name="id_jenis_pekerjaan" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach($jenis_pekerjaan as $val)
                            <option value="{{ $val->id }}" {{($dukcapil->id_jenis_pekerjaan == $val->id ? "selected" : "")}}>{{ $val->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>NIK Ibu</label>
                        <input type="text" name="nik_ibu" class="form-control" value="{{$dukcapil->nik_ibu}}">
                    </div>
                    <div class="col-md-6">
                        <label>Nama Ibu</label>
                        <input type="text" name="nama_ibu" class="form-control" value="{{$dukcapil->nama_ibu}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>NIK Ayah</label>
                        <input type="text" name="nik_ayah" class="form-control" value="{{$dukcapil->nik_ayah}}">
                    </div>
                    <div class="col-md-6">
                        <label>Nama Ayah</label>
                        <input type="text" name="nama_ayah" class="form-control" value="{{$dukcapil->nama_ibu}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Kepemilikan Akta Lahir</label>
                        <select name="kepemilikan_akta_lahir" class="form-control">
                            <option value="">-- Silakan Pilih --</option>
                            <option value="Ya" {{($dukcapil->kepemilikan_akta_lahir == "Ya" ? "selected" : "")}}>Ya</option>
                            <option value="Tidak" {{($dukcapil->kepemilikan_akta_lahir == "Tidak" ? "selected" : "")}}>Tidak</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Nomor Akta Lahir</label>
                        <input type="text" name="nomor_akta_lahir" class="form-control" value="{{$dukcapil->nomor_akta_lahir}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Kepemilikan Akta Kawin</label>
                        <select name="kepemilikan_akta_kawin" class="form-control">
                            <option value="">-- Silakan Pilih --</option>
                            <option value="Ya" {{($dukcapil->kepemilikan_akta_kawin == "Ya" ? "selected" : "")}}>Ya</option>
                            <option value="Tidak" {{($dukcapil->kepemilikan_akta_kawin == "Tidak" ? "selected" : "")}}>Tidak</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Nomor Akta Kawin</label>
                        <input type="text" name="nomor_akta_kawin" class="form-control" value="{{$dukcapil->nomor_akta_kawin}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Kepemilikan Akta Cerai</label>
                        <select name="kepemilikan_akta_cerai" class="form-control">
                            <option value="">-- Silakan Pilih --</option>
                            <option value="Ya" {{($dukcapil->kepemilikan_akta_cerai == "Ya" ? "selected" : "")}}>Ya</option>
                            <option value="Tidak" {{($dukcapil->kepemilikan_akta_cerai == "Tidak" ? "selected" : "")}}>Tidak</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Nomor Akta Cerai</label>
                        <input type="text" name="nomor_akta_cerai" class="form-control" value="{{$dukcapil->nomor_akta_cerai}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label>Tanggal Cerai</label>
                        <input type="date" name="tanggal_cerai" class="form-control" value="{{$dukcapil->tanggal_cerai}}">
                    </div>
                    <div class="col-md-4">
                        <label>Latitude</label>
                        <input type="text" name="latitude" class="form-control" required value="{{$dukcapil->latitude}}">
                    </div>
                    <div class="col-md-4">
                        <label>Longitude</label>
                        <input type="text" name="longitude" class="form-control" required value="{{$dukcapil->longitude}}">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" required value="{{$dukcapil->email}}">
                    </div>
                    <div class="col-md-6">
                        <label>Gambar</label>
                        <input type="file" name="foto" class="form-control">
                        <br>
                        <img src="{{ asset('foto_dukcapil/'.$dukcapil->foto) }}" height="200" alt="Tidak ada foto">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-body text-right">
            <a href="{{ url('dukcapil') }}" class="btn btn-secondary">Kembali</a>
            <button type="submit" class="btn btn-success">SIMPAN</button>
        </div>
    </div>
</form>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script>
    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kab_kota_by_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kecamatan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kecamatan_by_kab') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kabupaten_id: $("#id_kabupaten").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kelurahan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kelurahan_by_kecamatan') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kecamatan_id: $("#id_kecamatan").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
</script>
@endsection
