@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Detail Indikator</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="{{ url('/dukcapil') }}">Dukcapil</a></div>
      <div class="breadcrumb-item active"><a href="#">Layanan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        {!! $detail_dukcapil !!}
    </div>
  </div>
</div>
<div class="card card-primary">
  <div class="card-header">
    <h4>Layanan</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblDataLayanan" style="width:100%;">
            <thead>
                <tr>
                    <th>Layanan</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
  </div>
</div>

<div class="card card-primary">
  <div class="card-body text-right">
    <a href="{{ url('dukcapil') }}" class="btn btn-primary">Kembali</a>
  </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    $("#tblDataLayanan").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('layanans/status/get_data') }}",
        "columns": [
            // { data: 'user.nik', name: 'user.nik' },
            { data: 'layanan.nama', name: 'layanan.nama' },
            { data: 'status', name: 'status' },
            // { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });
</script>
@endsection
