@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/cssCustom/jquery.treeview.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Hak Akses</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Pengaturan</a></div>
      <div class="breadcrumb-item active"><a href="#">Hak Akses</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Hak Akses</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Hak Akses</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach($hak_akses as $value)                
            <tr>
              <td>{{$value->nama_hak_akses}}</td>
              <td>
                <a href ="{{ url('admin/hak-akses') }}/{{$value->id}}/edit" class="btn btn-primary">
                  Edit
                </a>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Menu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/hak-akses/tambah')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama Hak Akses</label> 
                                <input type="text" class="form-control" name="nama_hak_akses" required> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Hak Akses Menu</label> 
                                {!! $tree !!}
                            </div> 
                        </div> 
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/jsCustom/jquery-checktree.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/jsCustom/jquery.treeview.js') }}"></script>
<script>
    $("#tblData").DataTable();

    $('#tree').checktree();

    $(document).ready(function(){
        
        // first example
        $(".navigations").treeview({
        collapsed: true,
        persist: "location",
        control: "#treecontrol"
        });

    });
</script>
@endsection