@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/dropzonejs/dropzone.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail Kamar</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail Kamar</h4>

    <div class="card-header-action">
        <a href="{{ url('admin/hotel/edit/'.$kamar->id_hotel) }}" class="btn btn-secondary">
          Kembali
        </a>
    </div>
  </div>
  <div class="card-body">
    <table class="table" width="100%">
        <tr>
            <td width="20%">Nama Kamar</td>
            <td>: {{$kamar->nama}}</td>
        </tr>
        <tr>
            <td width="20%">Harga (per malam)</td>
            <td>: {{ number_format($kamar->harga)}}</td>
        </tr>
        <tr>
            <td width="20%">Kapasitas Tamu</td>
            <td>: {{$kamar->kapasitas_tamu}} Orang</td>
        </tr>
        <tr>
            <td width="20%">Luas (m<sup>2</sup>)</td>
            <td>: {{$kamar->sqm}}</td>
        </tr>
        <tr>
            <td width="20%">Kapasitas Ruangan Tersedia</td>
            <td>: {{$kamar->jumlah_tersedia}}</td>
        </tr>
        <tr>
            <td width="20%">Tanggal Tersedia</td>
            <td>: {{$kamar->tanggal_tersedia_awal}} s.d {{$kamar->tanggal_tersedia_akhir}}</td>
        </tr>
        <tr>
            <td width="20%">Status</td>
            <td>: {{ ($kamar->is_aktif == 1 ? 'Aktif' : 'Tidak Aktif' ) }}</td>
        </tr>
        <tr>
            <td width="20%">Fasilitas</td>
            <td>: {!! $kamar->fasilitas !!}</td>
        </tr>
        <tr>
            <td width="20%">Tipe Bed</td>
            <td>: {!! $kamar->tipe_bed !!}</td>
        </tr>
        <tr>
            <td width="20%">Tentang</td>
            <td>: {!! $kamar->about !!}</td>
        </tr>
    </table>
  </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Foto Kamar</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="upload_foto_kamar({{$kamar->id}});">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Gambar</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($foto_kamar as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td><a href="{{ asset('gambar_kamar/'.$val->id_room.'/'.$val->foto) }}"> <img src="{{ asset('gambar_kamar/'.$val->id_room.'/'.$val->foto) }}" width="150" height="100"> </a></td>
                    <td>
                        <a href="javascript:;" class="text-danger" onclick="hapus({{$val->id}})" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div id="modalContent" class="form-group">
                
            </div>
            
        </div>
    </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
    $("#tbl_jenis_list").DataTable();

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "{{ url('/admin/hotel/hapus_foto_kamar') }}/"+id;
            }
        });
    }

    function upload_foto_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Upload Foto Kamar");
        $.get("{{ url('admin/hotel/get_modal_foto_kamar') }}/" + id, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
@endsection
