@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/dropzonejs/dropzone.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/summernote/summernote-bs4.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Tambah Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="{{ url('admin/hotel') }}">Hotel</a></div>
      <div class="breadcrumb-item active"><a href="#">Tambah Hotel</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-body">
    <form action="{{ url('admin/hotel/simpan_update') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Provinsi</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="{{ $provinsi->name }}" readonly>
            </div>
        </div>
        @if ($id_kabupaten != null)
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Kabupaten</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="{{ $kabupaten->name }}" readonly>
            </div>
        </div>        
        @endif
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Tingkatan</label>
            <div class="col-sm-9">
                @if ($id == 0)
                <input type="text" class="form-control" name="tingkatan" value="{{$type == 'prov' ? 'Provinsi' : 'Kabupaten'}}" readonly>
                @else
                <input type="text" class="form-control" name="tingkatan" value="{{$layanan->tingkatan}}" readonly>
                @endif
                
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama Hotel</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="nama" name="nama" placeholder="Nama" value="{{ $id == 0 ? '' : $layanan->nama }}" required>
                <input type="hidden" class="form-control" id="id" name="id" value="{{ $id }}">
                <input type="hidden" class="form-control" id="id_provinsi" name="id_provinsi" value="{{ ($id == 0 ? $id_provinsi : $layanan->id_provinsi) }}">
                <input type="hidden" class="form-control" id="id_kabupaten" name="id_kabupaten" value="{{ ($id == 0 ? $id_kabupaten : $layanan->id_kabupaten) }}">
                <input type="hidden" class="form-control" id="type" name="type" value="{{ $type }}">
            </div>
        </div>
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Alamat</label>
            <div class="col-sm-9">
                <textarea class="form-control" name="alamat">{{ ($id == 0 ? "" : $layanan->alamat) }}</textarea>
            </div>
        </div>
        {{-- <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Gambar</label>
            <div class="col-sm-9">
                <div class="dropzone dz-clickable" id="mydropzone">
                    <div class="dz-default dz-message"><span>Drop files here to upload</span></div>
                </div>               

                @if($id == 0)
                <input type="file" class="form-control" id="image" name="image" required>
                @else
                <input type="file" class="form-control" id="image" name="image">
                <img src="{{ asset('layanan/'. $layanan->image) }}" height="150" width="150">
                @endif
            </div>
        </div> --}}
        {{-- <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Lokasi Pengambilan</label>
            <div class="col-sm-3">
                <select class="form-control" name="lokasi_pengambilan" id="lokasi_pengambilan" required>
                    <option value="Online" {{ ($id == 0 ? '' : ($layanan->lokasi_pengambilan == 'Online' ? 'selected' : '' )) }}>Online</option>
                    <option value="Offline" {{ ($id == 0 ? '' : ($layanan->lokasi_pengambilan == 'Offline' ? 'selected' : '' )) }}>Offline</option>
                </select>
            </div>
        </div> --}}
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Fasilitas</label>
            <div class="col-sm-9">
                <textarea name="fasilitas" id="fasilitas" class="summernote">{!! ($id == 0 ? "" : $layanan->fasilitas) !!}</textarea>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Latitude</label>
            <div class="col-sm-9">
                <input type="text" name="latitude" id="latitude" class="form-control" value="{{ ($id == 0 ? "" : $layanan->latitude) }}"/>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Longitude</label>
            <div class="col-sm-9">
                <input type="text" name="longitude" id="longitude" class="form-control" value="{{ ($id == 0 ? "" : $layanan->longitude) }}"/>
            </div>
        </div>
        
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Tentang</label>
            <div class="col-sm-9">
                <textarea name="tentang" id="tentang" class="summernote">{{ ($id == 0 ? "" : $layanan->tentang) }}</textarea>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama & No Rekening</label>
            <div class="col-sm-9">
                <input type="text" name="no_rekening" id="no_rekening" class="form-control" required value="{{ ($id == 0 ? "" : $layanan->no_rekening) }}"/>
            </div>
        </div>
        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Status</label>
            <div class="col-sm-3">
                <select class="form-control" name="status" id="status" required>
                    <option value="1" {{ ($id == 0 ? '' : ($layanan->is_aktif == 1 ? 'selected' : '' )) }}>Aktif</option>
                    <option value="0" {{ ($id == 0 ? '' : ($layanan->is_aktif == 0 ? 'selected' : '' )) }}>Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 text-right">
                <a href="{{ url('admin/hotel/index_detail?id_provinsi='.$id_provinsi.'&id_kabupaten='.$id_kabupaten.'&type='.$type) }}" class="btn btn-light">Kembali</a>
                @if($id == 0)
                    <button type="submit" class="btn btn-success">Simpan dan Lanjut</button>
                @else
                    <button type="submit" class="btn btn-success">Update</button>
                @endif
            </div>
        </div>
    </form>
  </div>
</div>

@if($id != 0)
<div class="card card-primary">
    <div class="card-header">
        <h4>Gambar Hotel</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('Gambar Hotel');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Gambar</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($hotel_foto as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td><a href="{{ asset('gambar_hotel/'.$val->id_hotel.'/'.$val->foto) }}"> <img src="{{ asset('gambar_hotel/'.$val->id_hotel.'/'.$val->foto) }}" width="150" height="100"> </a></td>
                    <td>
                        <a href="javascript:;" class="text-danger" onclick="hapus({{$val->id}})" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Kamar</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('Data Kamar');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_lampiran">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Harga</th>
                    <th>Kapasitas Tamu</th>
                    <th>Tentang</th>
                    <th>Luas (m<sup>2</sup>)</th>
                    <th>Fasilitas</th>
                    <th>Tipe Bed</th>
                    <th>Total Tersedia</th>
                    <th>Tanggal Tersedia</th>
                    <th>Foto</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($kamar as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td>{{ number_format($val->harga) }}</td>
                    <td>{{ $val->kapasitas_tamu }} Orang</td>
                    <td>{!! $val->about !!}</td>
                    <td>{{ $val->sqm }}</td>
                    <td>{!! $val->fasilitas !!}</td>
                    <td>{!! $val->tipe_bed !!}</td>
                    <td>{{ $val->jumlah_tersedia }}</td>
                    <td>{{ $val->tanggal_tersedia_awal }} s.d {{ $val->tanggal_tersedia_akhir }}</td>
                    <td><a href="javascript:;" class="text-primary" data-toggle="modal" data-target="#modal-tambah" onclick="upload_foto_kamar({{$val->id}});" title="Upload Foto"><i class="fas fa-upload"></i></a></td>
                    <td>
                        <a href="javascript:;" class="text-success" data-toggle="modal" data-target="#modal-tambah" onclick="edit_kamar({{$val->id}})" title="Edit"><i class="fas fa-pencil-alt"></i></a>
                        <a href="{{ url('admin/hotel/detail_kamar/'.$val->id) }}" class="text-primary" title="Detail"><i class="fas fa-eye"></i></a>
                        <a href="javascript:;" class="text-danger" onclick="hapus_kamar({{$val->id}})" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endif

@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div id="modalContent" class="form-group">
                
            </div>
            
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>

<script src="{{ asset('assets/bundles/summernote/summernote-bs4.js') }}"></script>

<script>
    $("#tbl_jenis_list").DataTable();
    $("#tbl_jenis_lampiran").DataTable();
    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "{{ url('admin/kelurahan/tambah') }}",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function GetModalContent(type)
    {
        $("#modalContent").empty();
        $("#formModal").text(type);
        $.get("{{ url('admin/hotel/get_modal_field') }}/" + type + "?id_hotel={{$id}}", function(result){
            $("#modalContent").html(result);
            $(".summernote").summernote();
        });
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "{{ url('/admin/hotel/hapus_gambar') }}/"+id;
            }
        });
    }

    function edit_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Edit Kamar");
        $.get("{{ url('admin/hotel/edit_kamar') }}/" + id, function(result){
            $("#modalContent").html(result);
            $(".summernote").summernote();
        });
    }

    function hapus_kamar(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "{{ url('/admin/hotel/hapus_kamar') }}/"+id;
            }
        });
    }

    function upload_foto_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Upload Foto Kamar");
        $.get("{{ url('admin/hotel/get_modal_foto_kamar') }}/" + id, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
@endsection
