@extends('layout.template')

@section('css')
<style>
    .form-group{
        margin:5px !important;
    }
</style>
@endsection

@section('isi')
<div class="section-header">
    <h1>Parameter</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Parameter</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Parameter</h4>
  </div>
  <div class="card-body">
    <form method="POST" class="form-horizontal" role="form" action="{{ url('/admin/indikator/parameter/simpan') }}">
            @csrf
            <input type="hidden" name="id_indikator" value="{{ $id_indikator }}">
            <div class="repeater-default">
            <div data-repeater-list="parameter" class="drag">

                    @if($parameter->count() > 0)
                        @foreach($parameter as $val)
                        <div data-repeater-item="">
                            <div class="row form-group">
                                <div class="col-md-8">
                                    <input type="text" class="form-control" placeholder="Parameter" name="parameter" value="{{ $val->nama }}" required>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" placeholder="Nilai"  step="any" name="nilai" value="{{ $val->nilai }}" required>
                                </div>
                                <div class="col-md-2">
                                    <span data-repeater-delete="" class="btn btn-danger btn-sm">
                                        <span class="glyphicon glyphicon-remove"></span> Hapus
                                    </span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    @else
                        <div data-repeater-item="">
                            <div class="row form-group">
                                <div class="col-md-8">
                                    <input type="text" class="form-control" placeholder="Parameter" name="parameter" required>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" placeholder="Nilai" name="nilai" step="any" required>
                                </div>
                                <div class="col-md-2">
                                    <span data-repeater-delete="" class="btn btn-danger btn-sm">
                                        <span class="glyphicon glyphicon-remove"></span> Hapus
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endif


            </div>
            <div class="row form-group">
                <div class="col-sm-12">
                    <span data-repeater-create="" class="btn btn-info btn-md">
                        <span class="glyphicon glyphicon-plus"></span> Tambah
                    </span>
                </div>
            </div>

            <hr>

            </div>
            <div class="row form-group">
                <div class="col-sm-12 text-center">
                    <a href="{{ url('/admin/indikator') }}" class="btn btn-secondary btn-lg">Kembali</a>
                    <input type="submit" value="SIMPAN" class="btn btn-primary btn-lg">
                </div>
            </div>
    </form>
  </div>
</div>


@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/js/form_repeater.js') }}"></script>
<script>
    var repeater = $('.repeater-default').repeater({
        initval: 1,
    });
</script>
@endsection
