@extends('layout.template')

@section('css')

@endsection

@section('isi')
<div class="section-header">
    <h1>Layanan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Layanan</a></div>
    </div>
</div>

<div class="row">
    @foreach($layanan as $val)
    <div class="col-12 col-sm-6 col-md-6 col-xs-6 col-lg-3">
        <article class="article">
            <div class="article-header">
                <div class="article-image" data-background="{{ asset('layanan/'. $val->image) }}" style="background-image: url({{ asset('layanan/'. $val->image) }});">
                    @if ($val->id_kabupaten == null)
                    <span class="badge badge-light" style="margin: 5px">Layanan Provinsi</span>    
                    @endif                    
                </div>
                <!-- <div class="article-title text-white">
                    <h2></h2>
                </div> -->
            </div>
            <div class="article-details">
                <b>{{ $val->nama }}</b>
                <p>{{$val->keterangan}} </p>
                <div class="article-cta">
                    <button class="btn btn-primary" onclick="GetForm({{$val->id}})" data-toggle="modal" data-target="#modal-tambah">DAFTAR</button>
                </div>
            </div>
        </article>
    </div>
    @endforeach
</div>

<div class="row">
    <div class="col-12">
        {!! $layanan->links() !!}
    </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Ajukan Layanan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="{{ url('layanans/daftar') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-body" id="modalContent">

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')

<script>
    function GetForm(id_layanan)
    {
        $("#modalContent").empty();
        // $("#formModal").text(type);
        $.get("{{ url('layanans/get_form') }}/" + id_layanan, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
@endsection
