@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Tambah Layanan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item"><a href="{{ url('admin/master/layanan') }}">Layanan</a></div>
      <div class="breadcrumb-item active"><a href="#">Tambah Layanan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-body">
    <form action="{{ url('admin/master/layanan/simpan_update') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama Layanan</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="nama" name="nama" placeholder="Nama" value="{{ $id == 0 ? '' : $layanan->nama }}" required>
                <input type="hidden" class="form-control" id="id" name="id" value="{{ $id }}">
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Gambar</label>
            <div class="col-sm-9">

                @if($id == 0)
                <input type="file" class="form-control" id="image" name="image" required>
                @else
                <input type="file" class="form-control" id="image" name="image">
                <img src="{{ asset('layanan/'. $layanan->image) }}" height="150" width="150">
                @endif
            </div>
        </div>

        @if(Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin)
        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Provinsi</label>
            <div class="col-sm-9">
                <select class="form-control select2" name="id_provinsi" id="id_provinsi" required>
                    @if($id==0)
                    <option value="">-- Pilih Provinsi --</option>
                    @else
                    <option value="{{ $provinsi->id }}">{{ $provinsi->name }}</option>
                    @endif

                </select>
            </div>
        </div>
        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Kabupaten/Kota</label>
            <div class="col-sm-9">
                <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" required>
                    @if($id==0)
                    <option value="">-- Pilih Kab/Kota --</option>
                    @else
                    <option value="{{ $kabupaten->id }}">{{ $kabupaten->name }}</option>
                    @endif

                </select>
            </div>
        </div>
        @endif
        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Status</label>
            <div class="col-sm-3">
                <select class="form-control" name="status" id="status" required>
                    <option value="1" {{ ($id == 0 ? '' : ($layanan->is_aktif == 1 ? 'selected' : '' )) }}>Aktif</option>
                    <option value="0" {{ ($id == 0 ? '' : ($layanan->is_aktif == 0 ? 'selected' : '' )) }}>Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Keterangan</label>
            <div class="col-sm-9">
                <textarea class="form-control" name="keterangan">{{($id == 0 ? "" : $layanan->keterangan )}}</textarea>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 text-right">
                <a href="{{ url('admin/master/layanan') }}" class="btn btn-light">Kembali</a>
                @if($id == 0)
                    <button type="submit" class="btn btn-success">Simpan dan Lanjut</button>
                @else
                    <button type="submit" class="btn btn-success">Update</button>
                @endif

            </div>
        </div>
    </form>
  </div>
</div>

@if($id != 0)
<div class="card card-primary">
    <div class="card-header">
        <h4>Jenis List</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('LIST');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Tipe</th>
                    <th>Wajib Isi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($layanan_field as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td>{{ $val->tipe }}</td>
                    <td>{{ ($val->is_required == 1 ? "Ya": "Tidak") }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Jenis Lampiran</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('LAMPIRAN');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_lampiran">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Jenis Lampiran</th>
                    <th>Wajib Isi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($layanan_field_lampiran as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td>{{ $val->jenis_file }}</td>
                    <td>{{ ($val->is_required == 1 ? "Ya": "Tidak") }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endif

@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="{{ url('admin/master/layanan/simpan_detail') }}">
                @csrf
                <input type="hidden" name="id_layanan" value="{{ $id }}">
                <div class="modal-body" id="modalContent">

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>
<script>
    $("#tbl_jenis_list").DataTable();
    $("#tbl_jenis_lampiran").DataTable();
    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kab_kota_by_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "{{ url('admin/kelurahan/tambah') }}",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function GetModalContent(type)
    {
        $("#modalContent").empty();
        $("#formModal").text(type);
        $.get("{{ url('admin/master/layanan/get_modal_field') }}/" + type, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
@endsection
