@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Menu</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Pengaturan</a></div>
      <div class="breadcrumb-item active"><a href="#">Menu</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Menu</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Induk</th>
                <th>Menu</th>
                <th>icon</th>
                <th>url</th>
                <th>No Urut</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Menu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/menu/tambah')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Induk</label> 
                                <select name="id_induk" class="form-control" id="id_induk"  required>
                                    <option value="0">Parent</option>
                                    @foreach($menu as $v)
                                        <option value="{{$v->id}}">{{$v->menu}}</option>
                                    @endforeach
                                </select> 
                                <input type="hidden" name="id_menu" id="id_menu">
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Menu</label> 
                                <input type="text" class="form-control" name="menu" id="menu" required> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Icon</label> 
                                <input type="text" class="form-control" name="icon" id="icon"> 
                            </div> 
                        </div> 
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">URL</label> 
                                <input type="text" class="form-control" name="url" id="url" required> 
                            </div> 
                        </div> 
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">No Urut</label> 
                                <input type="text" class="form-control" name="no_urut" id="no_urut" required> 
                            </div> 
                        </div> 
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/menu/get-data') }}",
        "columns": [
            { data: 'induk', name: 'induk' },                
            { data: 'menu', name: 'menu' },
            { data: 'icon', name: 'icon' },
            { data: 'url', name: 'url' },
            { data: 'no_urut', name: 'no_urut' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {  
        var url = "{{url('admin/menu')}}/"+id+"/edit";
        $("#id_induk").val("0");
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_induk").val(data.id_induk).trigger("change");
                // $("#id_induk").val(data.id_induk);
                $("#id_menu").val(data.id);
                $("#menu").val(data.menu);
                $("#icon").val(data.icon);
                $("#url").val(data.url);
                $("#page_title").val(data.page_title);
                $("#no_urut").val(data.no_urut);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_induk").val(0).trigger("change");
        $("#id_menu").val("");
        $("#menu").val("");
        $("#icon").val("");
        $("#url").val("");
        $("#page_title").val("");
        $("#no_urut").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus Menu ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/menu') }}/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }
</script>
@endsection