<form class="">
    <b>Wilayah Kedatangan</b>
    <hr>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <select class="form-control select2" name="id_kecamatan" id="id_kecamatan" required>
                <option value="">-- Pilih Kecamatan --</option>
            </select>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <select class="form-control select2" name="id_kelurahan" id="id_kelurahan" required>
                <option value="">-- Pilih Kelurahan --</option>
            </select>
        </div>
    </div>

    <br>
    <b>Data Pendaftaran</b>
    <hr>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-envelope"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="Email" name="email" required>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-phone"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="No. HP" name="no_hp" required>
        </div>
    </div>

    <br>
    <b>Data Kedatangan</b>
    <hr>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="No. SKPWNI" name="no_skpwni" required>
        </div>
    </div>
    <div class="form-group">
        <label>Alamat</label>
        <textarea class="form-control" name="alamat"></textarea>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="RT" name="rt" required>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="RW" name="rw" required>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="Kode POS" name="kode_pos" required>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <select class="form-control" name="id_lasifikasi_kepindahan" required>
                <option value="">-- Pilih Klasifikasi Kepindahan --</option>
                @foreach($klasifikasi as $val)
                <option value="{{ $val->id }}">{{$val->nama}}</option>
                @endforeach
            </select>
        </div>
    </div>

    <br>
    <b>Data Pengambilan</b>
    <hr>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-edit"></i>
            </div>
            </div>
            <input type="text" class="form-control" placeholder="Lokasi Pengambilan" name="lokasi_pengambilan" required>
        </div>
    </div>
    <div class="form-group">
        <!-- <label>Username</label> -->
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-calendar"></i>
            </div>
            </div>
            <input type="text" class="form-control datepicker" placeholder="Tanggal Pengambilan" name="tanggal_pengambilan" required>
        </div>
    </div>
    <div class="form-group mb-0">
        <div class="custom-control custom-checkbox">
            <input type="checkbox" name="remember" class="custom-control-input" id="remember-me">
            <label class="custom-control-label" for="remember-me"><small>DENGAN INI SAYA MENYATAKAN SETUJUI DENGAN SYARAT DAN KETENTUAN PELAYANAN APLIKASI E-OPEN</small></label>
        </div>
    </div>

    <br>
    <b>Upload Persyaratan</b>
    <hr>
    <div class="form-group">
        <label>Surat Keterangan Pindah Warga Negara Indonesia (SKPWNI) dari daerah asal</label>
        <div class="input-group">
            <div class="input-group-prepend">
            <div class="input-group-text">
                <i class="fas fa-upload"></i>
            </div>
            </div>
            <input type="file" class="form-control" name="upload_persyaratan" required>
        </div>
        <small>ukuran max upload: 700KB</small>
    </div>
    <button type="button" class="btn btn-primary m-t-15 waves-effect">SIMPAN</button>

    <div class="card" style="margin-top: 15px">
        <div class="card-header">
            <h4>Keterangan tambahan</h4>
        </div>
        <div class="card-body">
        <small>Pada saat pengambilan Surat Keterangan Datang Warga Negara Indonesia (SKDWNI), pemohon wajib membawa berkas asli Kartu Keluarga Daerah Asal, KTP Keluarga yang Pindah, Dokumen yang menunjukkan kepemilikan rumah (bila rumah/bangunan tersebut milik pemohon), Surat Izin Penggunaan Bangunan/Rumah untuk berdomisili (bila rumah/bangunan tersebut milik orang lain, atau surat izin dari pimpinan instansi bila alamat yang digunakan adalah gedung kantor dari alamat instansi yang bersangkutan (Berdasarkan Surat Dirjen Dukcapil Kemendagri No. 471.12/18749/DUKCAPIL Tentang Pindah Datang Penduduk)</small>
        </div>
    </div>

</form>

<script>
    $(".datepicker").daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });
    $("#id_kecamatan").select2({
        dropdownParent: $('#exampleModal'),
        minimumInputLength: 2,
        // tags: [],
        multiple: false,
        ajax: {
            url: "{{ url('get_kecamatan') }}",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.name,
                            id: item.id
                        }
                    })
                };
            }
        }
    });
    $("#id_kelurahan").select2({
        minimumInputLength: 2,
        dropdownParent: $('#exampleModal'),
        // tags: [],
        multiple: false,
        ajax: {
            url: "{{ url('get_kelurahan_by_kecamatan') }}",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term,
                    kecamatan_id: $("#id_kecamatan").val()
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.name,
                            id: item.id
                        }
                    })
                };
            }
        }
    });
</script>
