@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
@endsection

@section('isi')
<div class="section-header">
    {{-- <h1>Ajukan HAKI</h1> --}}
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Ajukan HAKI</a></div>
    </div>
</div>

@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form method="POST" action="{{ url('ajukan-haki/simpan') }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="id" value="0">
    <div class="card card-primary">
        {{-- <div class="card-header">
            <h4>Tambah Data</h4>
        </div> --}}
        <div class="card-body">

            <div class="form-group">
                <label class="text-dark">Nomor Surat Pengajuan <i class="text-success">*Optional</i></label>
                <input type="text" name="no_surat_pengajuan" class="form-control">
            </div>

            <div class="form-group">
                <label class="text-dark">Unggah Surat Pengajuan <i class="text-success">*(opsional | format: PDF/DOC/DOCX | maksimal 10 MB)</i></label>
                <input type="file" name="file_surat_pengajuan" class="form-control">
            </div>

            <div class="form-group">
                <label class="text-dark">Jenis Kekayaan Intelektual (KI) yang Diajukan</label>
                <select name="id_jenis_haki" id="id_jenis_haki" class="form-control" required onchange="getFormbyJenisHaki()">
                    <option value="">-- Silakan Pilih --</option>
                    @foreach ($jenis_haki as $val)
                    <option value="{{$val->id}}">{{$val->nama}}</option>
                    @endforeach
                </select>
            </div>

            <i class="fa fa-spinner fa-spin" id="loadingSpin"></i>
            <div id="divJenisHaki"></div>

            <div class="form-group">
                <label class="text-dark">Satuan Kerja - Pengusul <i class="text-danger">*(wajib diisi)</i></label>
                <select name="id_satuan_kerja" class="form-control" required>
                    <option value="0">-- Silakan Pilih --</option>
                    @foreach ($satuan_kerja as $val)
                    <option value="{{$val->id}}">{{$val->nama}}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label class="text-dark">Judul Kekayaan Intelektual (KI) <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="judul_kekayaan_intelektual" class="form-control" required></textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Abstrak / Penjelasan Singkat KI <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="abstrak_kekayaan_intelektual" class="form-control" required></textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Nomor Kontak / HP <i class="text-danger">*(wajib diisi)</i></label>
                <input type="text" name="telp" class="form-control" required>
            </div>

            <div class="form-group">
                <label class="text-dark">Alamat Email yang Dapat Dihubungi <i class="text-danger">*(wajib diisi)</i></label>
                <input type="email" name="email" class="form-control" required>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
            <h4>Unggah File Deskripsi KI <i class="text-danger">*(wajib dilampirkan | format: PDF/DOC/DOCX | maksimal 10 MB)</i></h4><br>
            {{-- <small class="text-muted ms-2">
            Maksimal 5 file (PDF/DOC/DOCX, max 10MB)
            </small> --}}
        </div>
        <div class="card-body">
            <div id="file-container">
                <!-- Item pertama -->
                <div class="form-group file-item">
                    <div class="row align-items-center">
                        <div class="col-md-4">
                            <input type="text"
                                   name="judul_file_pendukung[]"
                                   class="form-control"
                                   placeholder="Judul File (Wajib diisi)"
                                   required>
                        </div>

                        <div class="col-md-4">
                            <input type="file"
                                   name="file_pendukung[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx"
                                   required>
                            <small class="text-muted file-preview"></small>
                        </div>

                        <div class="col-md-2 text-danger file-error"></div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file">
                    <i class="fa fa-plus"></i> Tambah File Lain
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Internal <i class="text-danger">*(wajib diisi)</i></h4>
        </div>
        <div class="card-body">
            <div id="file-container-internal">
                <!-- Item pertama -->
                <div class="form-group file-item-internal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="nama_kolabolator_internal[]" class="form-control file-input" required>
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="instansi_kolabolator_internal[]" class="form-control file-input" required>
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_ktp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   required>
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_npwp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   required>
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-internal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-internal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Eksternal <i class="text-success">*(Jika ada)</i></h4>
        </div>
        <div class="card-body">
            <div id="file-container-eksternal">
                <!-- Item pertama -->
                <div class="form-group file-item-eksternal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama</label>
                            <input type="text" name="nama_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi</label>
                            <input type="text" name="instansi_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP</label>
                            <input type="file"
                                   name="file_ktp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP</label>
                            <input type="file"
                                   name="file_npwp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-eksternal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-eksternal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    {{-- <div class="card card-primary">
        <div class="card-header">
            <h4>Upload Files</h4>
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>1. Etiket/Label Merek (jpg atau jpeg) atau dokumen pendukung produk HaKI (Ciptaan, Lagu, Buku): dalam bentuk pdf, mp4, mp3 atau Ketentuan Etiket/Label yang diupload adalah gambar dengan format JPEG dengan dimensi pixel minimal 300x300 dan maksimal 1024x1024.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_etiket" class="form-control" required>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>2. KTP dalam bentuk pdf</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_ktp" class="form-control" required>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>3. Surat Pernyataan UMK/ Pelaku Ekonomi Kreatif Bermatera.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_pernyataan_umk" class="form-control" required>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>4. Surat Rekomendasi UMK Binaan Dinas (Asli) dari Dinas Terkait (Dinas koperasi dan UMKM, Dinas Perindustrian dan Perdagangan atau Dinas Pariwisata dan Kebudayaan).</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_rekomendasi_umk" class="form-control" required>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>5. Tanda tangan pemohon dalam bentuk JPG atau JPEG</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_tanda_tangan" class="form-control" required>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="card card-primary">
        <div class="card-body text-center">
            <a href="{{ url('ajukan-haki') }}" class="btn btn-warning text-white btn-lg">KEMBALI</a>
            <button type="submit" class="btn btn-success btn-lg">SIMPAN</button>
        </div>
    </div>
</form>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/js/ajukan_haki.js')}}"></script>
<script>
function getFormbyJenisHaki()
{
    $("#divJenisHaki").empty();
    var id_jenis_haki = $("#id_jenis_haki").val();
    $("#loadingSpin").hide();
    if(id_jenis_haki != 0)
    {
        $("#loadingSpin").show();
        $.get("{{ url('get-form-by-jenis-haki') }}/" + id_jenis_haki + "/0", function(response) {
            $("#divJenisHaki").empty();
            $("#divJenisHaki").html(response);
            $("#loadingSpin").hide();
        });
    }
}
getFormbyJenisHaki();
</script>
@endsection
