@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Jawaban Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="{{ url('/admin/ujian') }}">Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Jawaban Ujian</a></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
      <h4>Jawaban Ujian</h4>
    </div>
    <div class="card-body">
        <form id="fromMulaiUjian" method="POST" action="{{ url('admin/ujian/kirim')}}">
            @csrf

            @php
                $no = 1;
            @endphp
            @foreach ($jawaban_peserta as $item)
            
            <div class="card {{ $item->jawaban_benar == 1 ? "card-success" : "card-danger"}} ">
                <div class="card-header">
                    <h4>Skor = {{ $item->soal->skor }}</h4>
                </div>
                <div class="card-body">
                    <b>{{ $no }}). 
                    @if ($item->soal->file != null)
                        <br>
                        <img src="{{ asset('soal/'.$item->soal->file)}}" width="350" height="200" alt="Gambar Soal">
                        <br>
                        <br>
                    @endif
                    
                    {{ $item->soal->soal }}</b>

                    <br>
                    <br>
                    Jawaban : <br>

                    @php
                        $jawaban = \App\Models\Jawaban::where('id_soal', $item->id_soal)->get();
                    @endphp

                    @foreach ($jawaban as $items)
                        <div class="form-check">
                            <input class="form-check-input" disabled type="radio" name="jawaban_{{$items->id_soal}}" {{ $items->id == $item->id_jawaban ? "checked" : "" }} id="jawaban_{{$items->id}}" value="{{$items->id}}">
                            <label class="form-check-label" for="jawaban_{{$items->id}}">
                            {{ $items->jawaban }}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            @php
                $no++;
            @endphp
            @endforeach
            
            {{-- <input type="hidden" value="{{ $peserta->id_ujian }}" name="id_ujian">
            <input type="hidden" value="{{ $peserta->id_user }}" name="id_user"> --}}
            <a href="{{ url('admin/ujian/result/'.$peserta_ujian->id_ujian.'/'.$peserta_ujian->id_user) }}" class="btn btn-primary mt-4 text-white">KEMBALI</a>
        </form>  
    </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
@endsection