@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/dropzonejs/dropzone.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Wisata</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail Paket</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail Kamar</h4>

    <div class="card-header-action">
        <a href="{{ url('admin/wisata/edit/'.$paket->id_wisata) }}" class="btn btn-secondary">
          Kembali
        </a>
    </div>
  </div>
  <div class="card-body">
    <table class="table" width="100%">
        <tr>
            <td width="20%">Nama Paket</td>
            <td>: {{$paket->nama}}</td>
        </tr>
        <tr>
            <td width="20%">Harga</td>
            <td>: {{ number_format($paket->harga)}}</td>
        </tr>
        <tr>
            <td width="20%">Jumlah Orang</td>
            <td>: {{$paket->jumlah_orang}} Orang</td>
        </tr>
        <tr>
            <td width="20%">Tanggal Tersedia</td>
            <td>: {{$paket->tanggal_tersedia_awal}} s.d {{$paket->tanggal_tersedia_akhir}}</td>
        </tr>
        <tr>
            <td width="20%">Status</td>
            <td>: {{ ($paket->is_aktif == 1 ? 'Aktif' : 'Tidak Aktif' ) }}</td>
        </tr>
        <tr>
            <td width="20%">Fasilitas</td>
            <td>: {!! $paket->fasilitas !!}</td>
        </tr>
        <tr>
            <td width="20%">Keterangan</td>
            <td>: {!! $paket->about !!}</td>
        </tr>
    </table>
  </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Foto Paket</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="upload_foto_kamar({{$paket->id}});">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Gambar</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($foto_paket as $val)
                <tr>
                    <td>{{ $val->nama }}</td>
                    <td><a href="{{ asset('gambar_paket/'.$val->id_wisata_paket.'/'.$val->foto) }}"> <img src="{{ asset('gambar_paket/'.$val->id_wisata_paket.'/'.$val->foto) }}" width="150" height="100"> </a></td>
                    <td>
                        <a href="javascript:;" class="text-danger" onclick="hapus({{$val->id}})" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div id="modalContent" class="form-group">
                
            </div>
            
        </div>
    </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
    $("#tbl_jenis_list").DataTable();

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "{{ url('/admin/wisata/hapus_foto_paket') }}/"+id;
            }
        });
    }

    function upload_foto_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Upload Foto Paket");
        $.get("{{ url('admin/wisata/get_modal_foto_paket') }}/" + id, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
@endsection
