@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Formulir</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item active"><a href="#">Formulir</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Formulir</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Nama</th>
                <th>File</th>
                <th>Keterangan</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Menu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/master_formulir/tambah')}}" method="post" id="frm_menu" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Nama</label>
                                <input type="text" class="form-control" name="nama" id="nama" required>
                                <input type="hidden" name="id_formulir" id="id_formulir">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">File</label>
                                <input type="file" class="form-control" name="file" id="file">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Keterangan</label>
                                <textarea name="keterangan" id="keterangan" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/master_formulir/get-data') }}",
        "columns": [
            { data: 'nama', name: 'nama' },
            { data: 'file', name: 'file' },
            { data: 'keterangan', name: 'keterangan' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "{{url('admin/master_formulir')}}/"+id+"/edit";
        $("#id_formulir").val("0");
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_formulir").val(data.id);
                $("#nama").val(data.nama);
                $("#keterangan").val(data.keterangan);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_formulir").val("");
        $("#nama").val("");
        $("#keterangan").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus Menu ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/master_formulir') }}/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }
</script>
@endsection
