@extends('front_end.template_new')
@section('isi')
<section class="parallax-effect">
  <div id="parallax-pagetitle" style="background-image: url(./images/parallax/1900x911.gif);">
    <div class="color-overlay"> 
      <!-- Page title -->
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <ol class="breadcrumb">
              <li><a href="{{ url('/') }}">Home</a></li>
              <li class="active">Daftar Rooms</li>
            </ol>
            <h1>{{ $hotel->nama }}</h1>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Rooms -->
<section class="rooms mt100">
  <div class="container">
    <div class="row room-list fadeIn appear"> 

      @foreach ($room as $items)
      <!-- Room -->
      <div class="col-sm-4 single">
        <div class="room-thumb"> <img src="{{ SMUDESA::get_first_foto_kamar($items->id) }}" alt="room 1" class="img-responsive" />
          <div class="mask">
            <div class="main">
              <h5>{{ (Str::length($items->nama) > 20 ? Str::substr($items->nama, 0, 20).'...' : Str::substr($items->nama, 0, 20)) }}</h5>
              <div class="price">Rp. {{ number_format($items->harga) }}<span>per malam</span></div>
            </div>
            <div class="content">
              <p><span>Nama ruangan : </span> {{$items->nama}}</p>
              {{-- <p><span>Fasilitas : </span> {!! $items->fasilitas !!}</p> --}}
              
              <a href="{{ url('/front/hotel/booking_room/'.$items->id) }}" class="btn btn-primary btn-block">Booking</a> </div>
          </div>
        </div>
      </div>

      @endforeach
    </div>
  </div>
</section>

<div class="container">
  <div class="row"> 
    <!-- About -->
    <section class="about mt100">
      <div class="col-md-12">
        <h2 class="lined-heading bounceInRight appear" data-start="800"><span>Hotel Info</span></h2>
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
          <li class="active"><a href="#hotel" data-toggle="tab">Tentang</a></li>
          <li><a href="#events" data-toggle="tab">Fasilitas</a></li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
          <div class="tab-pane fade in active" id="hotel">
            {!! $hotel->tentang !!}
          </div>
          <div class="tab-pane fade" id="events">{!! $hotel->fasilitas !!}</div>
        </div>
      </div>
    </section>
  </div>
</div>

<section class="gallery-slider mt100">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <h2 class="lined-heading"><span>Gallery Hotel</span></h2>
      </div>
    </div>
  </div>
  <div id="owl-gallery" class="owl-carousel">
    @foreach ($hotel_foto as $item)
    <div class="item img-responsive"><a href="{{ asset('gambar_hotel/'.$item->id_hotel.'/'.$item->foto) }}" data-rel="prettyPhoto[gallery1]"><img src="{{ asset('gambar_hotel/'.$item->id_hotel.'/'.$item->foto) }}" alt="Image 1"><i class="fa fa-search"></i></a></div>
    @endforeach
  </div>
</section>
@endsection