@extends('front_end.template_new')
@section('isi')
<section class="parallax-effect">
  <div id="parallax-pagetitle" style="background-image: url(./images/parallax/1900x911.gif);">
    <div class="color-overlay"> 
      <!-- Page title -->
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <ol class="breadcrumb">
              <li><a href="{{ url('/') }}">Home</a></li>
              <li class="active">Daftar Paket</li>
            </ol>
            <h1>{{ $wisata->nama }}</h1>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Rooms -->
<section class="rooms mt100">
  <div class="container">
    <div class="row room-list fadeIn appear"> 

      @foreach ($paket as $items)
      <!-- Room -->
      <div class="col-sm-4 single">
        <div class="room-thumb"> <img src="{{ SMUDESA::get_first_foto_kamar($items->id) }}" alt="room 1" class="img-responsive" />
          <div class="mask">
            <div class="main">
              <h5>{{ (Str::length($items->nama) > 20 ? Str::substr($items->nama, 0, 20).'...' : Str::substr($items->nama, 0, 20)) }}</h5>
              <div class="price">Rp. {{ number_format($items->harga) }}<span>per malam</span></div>
            </div>
            <div class="content">
              <p><span>Nama paket : </span> {{$items->nama}}</p>
              {{-- <p><span>Fasilitas : </span> {!! $items->fasilitas !!}</p> --}}
              
              <a href="{{ url('/front/wisata/booking/'.$items->id) }}" class="btn btn-primary btn-block">Booking</a> </div>
          </div>
        </div>
      </div>

      @endforeach
    </div>
  </div>
</section>
@endsection