@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/ionicons/css/ionicons.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Detail Status</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="{{ url('layanans/status') }}">Status</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail</a></div>
    </div>
</div>
<form action="{{ url('layanans/status/update_status') }}" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="id_user_layanan" value="{{ $user_layanan->id }}">
    @csrf
<div class="card card-primary">
    <div class="card-header">
        <h4>Status</h4>
    </div>
    <div class="card-body">
        <div class="row">
            <div  class="col-md-12" id="accordion">
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-1" aria-expanded="false">
                        <h4>Data Layanan</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-1" style="">
                        <table>
                            <tr>
                                <td><b>Nama Layanan</b></td>
                                <td>: {{ $user_layanan->layanan->nama ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><b>Tingkatan</b></td>
                                <td>: {{ $user_layanan->layanan->tingkatan ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><b>Lokasi Pengambilan</b></td>
                                <td>: {{ $user_layanan->layanan->lokasi_pengambilan ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><b>Status</b></td>
                                <td>: {{ $user_layanan->status }}</td>
                            </tr>
                            <tr>
                                <td><b>Keterangan</b></td>
                                <td>: {{ $user_layanan->layanan->keterangan ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td colspan="2">&nbsp;</td>
                            </tr>                       
                            <tr>
                                <td><b>No Layanan</b></td>
                                <td>: {{ $user_layanan->no_layanan }}</td>
                            </tr>
                            <tr>
                                <td><b>Kode ID</b></td>
                                <td>: {{ $user_layanan->kode }}</td>
                            </tr>  
                            <tr>
                                <td><b>NIK</b></td>
                                <td>: {{ $user_layanan->nik }}</td>
                            </tr>  
                            <tr>
                                <td><b>No KK</b></td>
                                <td>: {{ $user_layanan->no_kk }}</td>
                            </tr>  
                            <tr>
                                <td><b>Nama Lengkap</b></td>
                                <td>: {{ $user_layanan->nama_lengkap }}</td>
                            </tr>  
                            <tr>
                                <td><b>Provinsi</b></td>
                                <td>: {{ $user_layanan->provinsi->name ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td><b>Kabupaten/Kota</b></td>
                                <td>: {{ $user_layanan->kabupaten->name ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td><b>Kecamatan</b></td>
                                <td>: {{ $user_layanan->kecamatan->name ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td><b>Kelurahan</b></td>
                                <td>: {{ $user_layanan->kelurahan->name ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td><b>Status</b></td>
                                <td>: {{ $user_layanan->status ?? '-' }}</td>
                            </tr> 
                            <tr>
                                <td><b>File Download</b></td>
                                <td>: 
                                    @if ($user_layanan->file_upload == null)
                                        <span>-</span>
                                    @else
                                    <a href="{{ asset('user_layanan/'. $user_layanan->file_upload) }}" target="_blank"><i class="fa fa-download"></i></a>
                                    @endif
                                    
                                </td>
                            </tr> 
                        </table>
                    </div>
                </div>
                
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-3">
                        <h4>List</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-3">
                        <table>
                            @foreach($user_layanan_detail->where('tipe','<>','File') as $val)
                            <tr>
                                <td><b>{{ $val->layanan_field->nama }}</b></td>
                                <td>: {{ $val->value }}</td>
                            </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-4">
                        <h4>Lampiran</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-4">
                        <table>
                            @foreach($user_layanan_detail->where('tipe','File') as $val)
                            <tr>
                                <td><b>{{ $val->layanan_field->nama }}</b></td>
                                <td>: <a href="{{ asset('user_layanan/'.$val->value) }}"><i class="fas fa-download"></i> Download</a></td>
                            </tr>
                            @endforeach
                        </table>
                    </div>
                </div>

                @if(Auth::user()->id_hak_akses != 2)

                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-2" aria-expanded="false">
                        <h4>Update Status</h4>
                    </div>
                    <div class="accordion-body" id="panel-body-2" style="">
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Status</label>
                                <div class="col-md-6">
                                    <select class="form-control" id="status" name="status" onchange="set_status()">
                                        <option value="{{ \App\Models\UserLayanan::Permohonan }}" {{ \App\Models\UserLayanan::Permohonan == $user_layanan->status ? "selected" : "" }}>{{ \App\Models\UserLayanan::Permohonan }}</option>
                                        <option value="{{ \App\Models\UserLayanan::MenungguKonfirmasi }}" {{ \App\Models\UserLayanan::MenungguKonfirmasi == $user_layanan->status ? "selected" : "" }}>{{ \App\Models\UserLayanan::MenungguKonfirmasi }}</option>
                                        <option value="{{ \App\Models\UserLayanan::Proses }}" {{ \App\Models\UserLayanan::Proses == $user_layanan->status ? "selected" : "" }}>{{ \App\Models\UserLayanan::Proses }}</option>
                                        <option value="{{ \App\Models\UserLayanan::Dikembalikan }}" {{ \App\Models\UserLayanan::Dikembalikan == $user_layanan->status ? "selected" : "" }}>{{ \App\Models\UserLayanan::Dikembalikan }}</option>
                                        <option value="{{ \App\Models\UserLayanan::Selesai }}" {{ \App\Models\UserLayanan::Selesai == $user_layanan->status ? "selected" : "" }}>{{ \App\Models\UserLayanan::Selesai }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group divHide">
                            <div class="row">
                                <label class="col-md-3">File Upload</label>
                                <div class="col-md-6">
                                    <input type="file" name="file_upload" id="file_upload">
                                </div>
                            </div>
                        </div>
                        <div class="form-group divHide">
                            <div class="row">
                                <label class="col-md-3">Komentar</label>
                                <div class="col-md-6">
                                    <textarea class="form-control" name="komentar" id="komentar">{{ $user_layanan->komentar }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @endif

                
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 text-center">
                <a href="{{ url('layanans/status') }}" class="btn btn-secondary"> Kembali</a>
                @if(Auth::user()->id_hak_akses != 2)
                <button type="submit" class="btn btn-primary"> Simpan</button>
                @endif
            </div>
        </div>
    </div>
</div>
</form>
@endsection

@section('modal')
@endsection

@section('js')

<script>
    set_status()
    function set_status()
    {
        var status = $("#status").val();

        if(status == "Dikembalikan" || status == "Selesai")
        {
            $(".divHide").show();
        }
        else
        {
            $(".divHide").hide();
        }
    }
</script>
@endsection
