<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>{{ config('app.name') }}</title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="{{ asset('assets/css/app.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/bundles/prism/prism.css') }}">
  <!-- Template CSS -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/components.css') }}">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
  <link rel='shortcut icon' type='image/x-icon' href="{{ asset('assets/img/favicon.ico') }}" />
  <meta name="csrf-token" content="{{ csrf_token() }}" />

  @yield('css')
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <div class="navbar-bg"></div>
      <nav class="navbar navbar-expand-lg main-navbar">
        <div class="form-inline mr-auto">
          <ul class="navbar-nav mr-3">
            <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn"><i
                  class="fas fa-bars"></i></a></li>
            <li><a href="#" class="nav-link nav-link-lg fullscreen-btn">
                <i class="fas fa-expand"></i>
              </a>
            </li>
          </ul>
        </div>
        <ul class="navbar-nav navbar-right">
          <li class="dropdown"><a href="#" data-toggle="dropdown"
              class="nav-link dropdown-toggle nav-link-lg nav-link-user">
              {{-- <img alt="image" src="{{ asset('assets/img/user.png') }}" class="user-img-radious-style"> --}}
              <figure class="avatar mr-2 avatar-sm bg-warning text-white" data-initial="{{Auth::user()->initials}}"></figure>
              <span class="d-sm-none d-lg-inline-block"></span></a>
            <div class="dropdown-menu dropdown-menu-right">
              <div class="dropdown-title">Hello {{ Auth::user()->name }}</div>
                {{-- <a href="{{ url('/admin/profile')}}" class="dropdown-item has-icon">
                  <i class="far fa-user"></i> Profile
                </a> --}}
              {{-- <a href="#" class="dropdown-item has-icon">
                <i class="far fa-user"></i> Profile
              </a>
              <a href="#" class="dropdown-item has-icon">
                <i class="fas fa-bolt"></i> Activities
              </a>
              <a href="#" class="dropdown-item has-icon">
                <i class="fas fa-cog"></i> Settings
              </a> --}}
              <div class="dropdown-divider"></div>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                <a href="#" onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item has-icon text-danger">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
                </form>
            </div>
          </li>
        </ul>
      </nav>
      <div class="main-sidebar sidebar-style-2">
        <aside id="sidebar-wrapper">
          <div class="sidebar-brand">
            <a href="{{ url('dashboard') }}">
              {{-- <img alt="image" src="{{ asset('assets/img/logo.png') }}" class="header-logo" /> --}}
              <span class="logo-name">{{ config('app.name') }}</span>
            </a>
          </div>
          <ul class="sidebar-menu">
            <li class="menu-header">Main</li>
            <li>
                <a class="nav-link" href="{{ url('/dashboard') }}"><i class="fas fa-home"></i><span>Dashboard</span></a>
            </li>
            {{-- <li>
              <a class="nav-link" href="{{ url('admin/profile') }}"><i class="fas fa-angle-double-right"></i><span>Profile</span></a>
            </li> --}}
            <li>
                <a class="nav-link" href="{{ url('/ajukan-haki') }}"><i class="fas fa-angle-double-right"></i><span>Ajukan HAKI</span></a>
            </li>
            <li>
                <a class="nav-link" href="{{ url('/perbaikan-haki') }}"><i class="fas fa-angle-double-right"></i><span>Perbaikan HAKI</span></a>
            </li>
            <li>
                <a class="nav-link" href="{{ url('/bukti-bayar') }}"><i class="fas fa-angle-double-right"></i><span>Upload Bukti Bayar</span></a>
            </li>
            {{-- <li>
                <a class="nav-link" href="{{ url('/layanans') }}"><i class="fas fa-angle-double-right"></i><span>Layanan</span></a>
            </li>
            <li>
                <a class="nav-link" href="{{ url('/layanans/status') }}"><i class="fas fa-angle-double-right"></i><span>Status</span></a>
            </li> --}}
            {{-- <li>
                <a class="nav-link" href="#"><i class="fas fa-angle-double-right"></i><span>Halo Pamor</span></a>
            </li>
            <li>
                <a class="nav-link" href="#"><i class="fas fa-angle-double-right"></i><span>Buku Petunjuk</span></a>
            </li> --}}
            {{-- <li>
                <a class="nav-link" href="{{ url('/formulirs') }}"><i class="fas fa-angle-double-right"></i><span>Formulir</span></a>
            </li>
            <li>
                <a class="nav-link" href="{{ url('/dukcapil') }}"><i class="fas fa-angle-double-right"></i><span>Indikator</span></a>
            </li>
            <li>
                <a class="nav-link" href="{{ url('/peta') }}"><i class="fas fa-angle-double-right"></i><span>Peta</span></a>
            </li> --}}

            @if (Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin || Auth::user()->id_hak_akses == \App\Models\HakAkses::AdminProvinsi || Auth::user()->id_hak_akses == \App\Models\HakAkses::AdminKabupaten)
              {{-- Hak Admin --}}

              <li class="menu-header">Admin</li>

              <li>
                <a class="nav-link" href="{{ url('/admin/management-user') }}"><i class="fas fa-users"></i><span>Akun</span></a>
              </li>

              <li class="dropdown">
                <a href="#" class="nav-link has-dropdown"><i class="fas fa-database"></i><span>Master Data</span></a>
                {{-- <ul class="dropdown-menu">
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Layanan</a></li>
                </ul> --}}

                @if(Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin)

                <ul class="dropdown-menu">
                  <!-- <li><a class="nav-link" href="{{ url('/admin/aspek') }}">Aspek</a></li> -->
                  {{-- <li><a class="nav-link" href="{{ url('/admin/variabel') }}">Variabel</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/indikator') }}">Indikator</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master_formulir') }}">Formulir</a></li> --}}
                  <li><a class="nav-link" href="{{ url('/admin/jenis-haki') }}">Jenis Haki</a></li>
                  {{-- <li><a class="nav-link" href="{{ url('/admin/provinsi') }}">Provinsi</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/kabupaten') }}">Kab/Kota</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/kecamatan') }}">Kecamatan</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/kelurahan') }}">Kelurahan/Desa</a></li> --}}
                </ul>
                @endif
              </li>

              @if(Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin)
              {{-- <li class="menu-header">Hotel</li>
              <li>
                <a class="nav-link" href="{{ url('admin/hotel') }}"><i class="fas fa-angle-double-right"></i><span>Hotel</span></a>
              </li>
              <li>
                <a class="nav-link" href="{{ url('/peta') }}"><i class="fas fa-angle-double-right"></i><span>Status</span></a>
              </li> --}}
              {{-- <li>
                <a class="nav-link" href="{{ url('/peta') }}"><i class="fas fa-angle-double-right"></i><span>Booking</span></a>
              </li>
              <li class="dropdown">
                <a href="#" class="nav-link has-dropdown"><i class="fas fa-cogs"></i><span>Konfigurasi</span></a>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Hotel</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Ruangan</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Kategori Fasilitas</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Fasilitas</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Feature</a></li>
                  <li><a class="nav-link" href="{{ url('/admin/master/layanan') }}">Tipe Bed</a></li>
                </ul>
              </li> --}}

              {{-- <li class="menu-header">Wisata</li>
              <li>
                <a class="nav-link" href="{{ url('admin/wisata') }}"><i class="fas fa-angle-double-right"></i><span>Wisata</span></a>
              </li>
              <li>
                <a class="nav-link" href="{{ url('/peta') }}"><i class="fas fa-angle-double-right"></i><span>Status</span></a>
              </li> --}}

              @endif
            @endif

          </ul>
        </aside>
      </div>
      <!-- Main Content -->

      <div class="main-content">
        <section class="section">
          <div class="section-body">
            @yield('isi')
          </div>
        </section>
        @yield('modal')
      </div>
      <footer class="main-footer">
        <div class="footer-left">
          Copyright &copy; {{ date('Y') }} <div class="bullet"></div> Design By <a href="{{ url('dashboard') }}">Dani Kurniawan</a>
        </div>
        <div class="footer-right">
        </div>
      </footer>
    </div>
  </div>
  <!-- General JS Scripts -->
  <script src="{{ asset('assets/js/app.min.js') }}"></script>

  <script src="{{ asset('assets/bundles/sweetalert/sweetalert.min.js') }}"></script>
  <script src="{{ asset('assets/bundles/prism/prism.js') }}"></script>
  <script src="{{ asset('assets/bundles/jquery-ui/jquery-ui.min.js') }}"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->

  <script>
    $(window).on('load', function () {
        @if(Session::has('pesan'))
        swal({
            title: "{{ Session::get('pesan.header') }}",
            text: "{{ Session::get('pesan.message') }}",
            icon: "{{ Session::get('pesan.alert-type') }}",
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Ok',
        });

        @endif
    });
  </script>



  <script src="{{ asset('assets/js/scripts.js') }}"></script>
  @yield('js')
  <!-- Custom JS File -->
  <script src="{{ asset('assets/js/custom.js') }}"></script>


</body>

</html>
