@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Ajukan HAKI</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Ajukan HAKI</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Pengajuan HAKI</h4>

    <div class="card-header-action">
        <a href="{{ url('ajukan-haki/tambah') }}" class="btn btn-primary text-white">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Kode Pengajuan</th>
                <th>Nama Pemohon</th>
                <th>email</th>
                <th>Telp</th>
                <th>Nama Produk</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('ajukan-haki/get-data') }}",
        "columns": [
            { data: 'kode_pengajuan', name: 'kode_pengajuan' },
            { data: 'nama_pemohon', name: 'nama_pemohon' },
            { data: 'email', name: 'email' },
            { data: 'telp', name: 'telp' },
            { data: 'nama_produk', name: 'nama_produk' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    // function edit_data(id)
    // {
    //     var url = "{{url('admin/pengajar')}}/"+id+"/edit";

    //     $.ajax({
    //         url: url,
    //         type: "GET",
    //         success: function(data){
    //             $("#id").val(data.id);
    //             $("#nama").val(data.nama);
    //             $("#email").val(data.email);
    //             $("#jenis_kelamin").val(data.jenis_kelamin);
    //             $("#no_telp").val(data.no_telp);
    //             $("#alamat").val(data.alamat);
    //         },
    //         error: function(data){
    //             alert('Hubungi Admin !');
    //         }
    //     });
    // }

    // function bersih()
    // {
    //     $("#id").val("");
    //     $("#nama").val("");
    //     $("#email").val("");
    //     $("#jenis_kelamin").val("");
    //     $("#no_telp").val("");
    //     $("#alamat").val("");
    // }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('ajukan-haki') }}/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    // $("#frm_data").on("submit", function(e){
    //     e.preventDefault();
    //     $("#modal-tambah").modal('hide');
    //     $.ajax({
    //         type:"POST",
    //         url: "{{ url('admin/pengajar/tambah') }}",
    //         data: $(this).serialize(),
    //         success: function(result){
    //             table_data.ajax.reload();

    //             if(result.issuccess)
    //                 swal("Sukses", result.message, "success");
    //             else
    //                 swal("Gagal", result.message, "error");
    //         }
    //     })
    // });
</script>
@endsection
