@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Perbaikan HAKI</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Perbaikan HAKI</a></div>
    </div>
</div>
<form method="POST" action="{{ url('perbaikan-haki/simpan') }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="id" value="0">
    <div class="card card-primary">
        <div class="card-header">
            <h4>Tambah Data</h4>
        </div>
        <div class="card-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Kode Pengajuan</label>
                        <select name="kode_pengajuan" id="kode_pengajuan" class="form-control" onchange="get_detail_pengajuan()" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach ($pengajuan_haki as $val)
                            <option value="{{$val->kode_pengajuan}}">{{$val->kode_pengajuan}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Nama Pemohon (Nama lengkap & tanpa Gelar)</label>
                        <input type="text" name="nama_pemohon" id="nama_pemohon" class="form-control" required>
                        <input type="hidden" name="id_pengajuan_haki" id="id_pengajuan_haki" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label>Pekerjaan</label>
                        <input type="text" name="pekerjaan" id="pekerjaan" class="form-control" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Email</label>
                        <input type="text" name="email" id="email" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label>No. Telepon</label>
                        <input type="text" name="telp" id="telp" class="form-control" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Alamat</label>
                        <textarea name="alamat" id="alamat" class="form-control" required></textarea>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Nama Produk</label>
                        <input type="text" name="nama_produk" id="nama_produk" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label>Jenis Haki</label>
                        <select name="id_jenis_haki" id="id_jenis_haki" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach ($jenis_haki as $val)
                            <option value="{{$val->id}}">{{$val->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Deskripsi Produk</label>
                        <textarea name="deskripsi_produk" id="deskripsi_produk" class="form-control"></textarea>
                    </div>
                    <div class="col-md-6">
                        <label>Jumlah Produk</label>
                        <input type="number" name="jumlah_produk" id="jumlah_produk" class="form-control" required>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
            <h4>Upload Files</h4>
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>1. Etiket/Label Merek (jpg atau jpeg) atau dokumen pendukung produk HaKI (Ciptaan, Lagu, Buku): dalam bentuk pdf, mp4, mp3 atau Ketentuan Etiket/Label yang diupload adalah gambar dengan format JPEG dengan dimensi pixel minimal 300x300 dan maksimal 1024x1024.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_etiket" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>2. KTP dalam bentuk pdf</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_ktp" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>3. Surat Pernyataan UMK/ Pelaku Ekonomi Kreatif Bermatera.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_pernyataan_umk" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>4. Surat Rekomendasi UMK Binaan Dinas (Asli) dari Dinas Terkait (Dinas koperasi dan UMKM, Dinas Perindustrian dan Perdagangan atau Dinas Pariwisata dan Kebudayaan).</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_rekomendasi_umk" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>5. Tanda tangan pemohon dalam bentuk JPG atau JPEG</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_tanda_tangan" class="form-control">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-body text-right">
            <a href="{{ url('perbaikan-haki') }}" class="btn btn-secondary">Kembali</a>
            <button type="submit" class="btn btn-success">SIMPAN</button>
        </div>
    </div>
</form>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script>

function get_detail_pengajuan()
{
    var kode_pengajuan = $("#kode_pengajuan").val();

    var url = "{{url('perbaikan-haki/get-pengajuan-haki/')}}/"+kode_pengajuan;

    $.ajax({
        url: url,
        type: "GET",
        success: function(data){
            $("#nama_pemohon").val(data.nama_pemohon);
            $("#id_pengajuan_haki").val(data.id);
            $("#pekerjaan").val(data.pekerjaan);
            $("#email").val(data.email);
            $("#telp").val(data.telp);
            $("#alamat").val(data.alamat);
            $("#nama_produk").val(data.nama_produk);
            $("#id_jenis_haki").val(data.id_jenis_haki);
            $("#deskripsi_produk").val(data.deskripsi_produk);
            $("#jumlah_produk").val(data.jumlah_produk);
        },
        error: function(data){
            alert('Hubungi Admin !');
        }
    });
}
</script>
@endsection
