@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="{{ url('/admin/ujian') }}">Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Open</a></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
      <h4>Ujian</h4>
    </div>
    <div class="card-body">
        <form id="fromMulaiUjian" method="POST" action="{{ url('admin/ujian/kirim')}}">
            @csrf
            <input type="hidden" name="id_ujian" value="{{ $ujian->id }}">
            <input type="hidden" name="id_program" value="{{ $id_program }}">
            <input type="hidden" name="id_peserta_ujian" value="{{ $id_peserta_ujian }}">
            <h6 id="SisaWaktu"></h6>

            @php
                $no = 1;
            @endphp
            @foreach ($soal as $item)
            <input type="hidden" name="id_soal[]" value="{{ $item->id }}">
            <div class="card card-secondary">
                <div class="card-header">
                    <h4>Skor = {{ $item->skor }}</h4>
                  </div>
                <div class="card-body">
                    <b>{{ $no }}). 

                    @if ($item->file != null)
                        <br>
                        <img src="{{ asset('soal/'.$item->file)}}" width="350" height="200" alt="Gambar Soal">
                        <br>
                        <br>
                    @endif    
                    {{ $item->soal }}</b>

                    <br>
                    <br>
                    Jawaban : <br>

                    @php
                        $jawaban = \App\Models\Jawaban::where('id_soal', $item->id)->get();
                    @endphp

                    @foreach ($jawaban as $items)
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="jawaban_{{$items->id_soal}}" id="jawaban_{{$items->id}}" value="{{$items->id}}">
                            <label class="form-check-label" for="jawaban_{{$items->id}}">
                            {{ $items->jawaban }}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            @php
                $no++;
            @endphp
            @endforeach
            
            {{-- <input type="hidden" value="{{ $peserta->id_ujian }}" name="id_ujian">
            <input type="hidden" value="{{ $peserta->id_user }}" name="id_user"> --}}
            <button type="button" onclick="KirimUjian()" class="btn btn-success mt-4 btn-lg text-white">SUBMIT</button>
        </form>  
    </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script>
    // Set the date we're counting down to
    var countDownDate = new Date("{{$ujian->tanggal}} {{$ujian->jam_selesai}}").getTime();

    // Update the count down every 1 second111
    var x = setInterval(function() {

    // Get today's date and time
    var now = new Date().getTime();
        
    // Find the distance between now and the count down date
    var distance = countDownDate - now;
        
    // Time calculations for days, hours, minutes and seconds
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
    
    // Output the result in an element with id="demo"
    document.getElementById("SisaWaktu").innerHTML = "Sisa Waktu = " + days + "d " + hours + "h "
    + minutes + "m " + seconds + "s ";
        
    // If the count down is over, write some text 
    if (distance < 0) {
        clearInterval(x);
        swal({
            title: "Waktu anda habis!",
            text: "Terima kasih telah mengikuti ujian",
            icon: "warning"
        }).then((willDelete) => {
            $("#fromMulaiUjian").submit();
        });
    }
    }, 1000);

    function KirimUjian()
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan kirim ujian!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $("#fromMulaiUjian").submit();
            }
        });
    }
</script>
@endsection