

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/dropzonejs/dropzone.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/summernote/summernote-bs4.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Tambah Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('admin/hotel')); ?>">Hotel</a></div>
      <div class="breadcrumb-item active"><a href="#">Tambah Hotel</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-body">
    <form action="<?php echo e(url('admin/hotel/simpan_update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Provinsi</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="<?php echo e($provinsi->name); ?>" readonly>
            </div>
        </div>
        <?php if($id_kabupaten != null): ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Kabupaten</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="<?php echo e($kabupaten->name); ?>" readonly>
            </div>
        </div>        
        <?php endif; ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Tingkatan</label>
            <div class="col-sm-9">
                <?php if($id == 0): ?>
                <input type="text" class="form-control" name="tingkatan" value="<?php echo e($type == 'prov' ? 'Provinsi' : 'Kabupaten'); ?>" readonly>
                <?php else: ?>
                <input type="text" class="form-control" name="tingkatan" value="<?php echo e($layanan->tingkatan); ?>" readonly>
                <?php endif; ?>
                
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama Hotel</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="nama" name="nama" placeholder="Nama" value="<?php echo e($id == 0 ? '' : $layanan->nama); ?>" required>
                <input type="hidden" class="form-control" id="id" name="id" value="<?php echo e($id); ?>">
                <input type="hidden" class="form-control" id="id_provinsi" name="id_provinsi" value="<?php echo e(($id == 0 ? $id_provinsi : $layanan->id_provinsi)); ?>">
                <input type="hidden" class="form-control" id="id_kabupaten" name="id_kabupaten" value="<?php echo e(($id == 0 ? $id_kabupaten : $layanan->id_kabupaten)); ?>">
                <input type="hidden" class="form-control" id="type" name="type" value="<?php echo e($type); ?>">
            </div>
        </div>
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Alamat</label>
            <div class="col-sm-9">
                <textarea class="form-control" name="alamat"><?php echo e(($id == 0 ? "" : $layanan->alamat)); ?></textarea>
            </div>
        </div>
        
        
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Fasilitas</label>
            <div class="col-sm-9">
                <textarea name="fasilitas" id="fasilitas" class="summernote"><?php echo ($id == 0 ? "" : $layanan->fasilitas); ?></textarea>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Latitude</label>
            <div class="col-sm-9">
                <input type="text" name="latitude" id="latitude" class="form-control" value="<?php echo e(($id == 0 ? "" : $layanan->latitude)); ?>"/>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Longitude</label>
            <div class="col-sm-9">
                <input type="text" name="longitude" id="longitude" class="form-control" value="<?php echo e(($id == 0 ? "" : $layanan->longitude)); ?>"/>
            </div>
        </div>
        
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Tentang</label>
            <div class="col-sm-9">
                <textarea name="tentang" id="tentang" class="summernote"><?php echo e(($id == 0 ? "" : $layanan->tentang)); ?></textarea>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama & No Rekening</label>
            <div class="col-sm-9">
                <input type="text" name="no_rekening" id="no_rekening" class="form-control" required value="<?php echo e(($id == 0 ? "" : $layanan->no_rekening)); ?>"/>
            </div>
        </div>
        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Status</label>
            <div class="col-sm-3">
                <select class="form-control" name="status" id="status" required>
                    <option value="1" <?php echo e(($id == 0 ? '' : ($layanan->is_aktif == 1 ? 'selected' : '' ))); ?>>Aktif</option>
                    <option value="0" <?php echo e(($id == 0 ? '' : ($layanan->is_aktif == 0 ? 'selected' : '' ))); ?>>Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 text-right">
                <a href="<?php echo e(url('admin/hotel/index_detail?id_provinsi='.$id_provinsi.'&id_kabupaten='.$id_kabupaten.'&type='.$type)); ?>" class="btn btn-light">Kembali</a>
                <?php if($id == 0): ?>
                    <button type="submit" class="btn btn-success">Simpan dan Lanjut</button>
                <?php else: ?>
                    <button type="submit" class="btn btn-success">Update</button>
                <?php endif; ?>
            </div>
        </div>
    </form>
  </div>
</div>

<?php if($id != 0): ?>
<div class="card card-primary">
    <div class="card-header">
        <h4>Gambar Hotel</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('Gambar Hotel');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Gambar</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $hotel_foto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($val->nama); ?></td>
                    <td><a href="<?php echo e(asset('gambar_hotel/'.$val->id_hotel.'/'.$val->foto)); ?>"> <img src="<?php echo e(asset('gambar_hotel/'.$val->id_hotel.'/'.$val->foto)); ?>" width="150" height="100"> </a></td>
                    <td>
                        <a href="javascript:;" class="text-danger" onclick="hapus(<?php echo e($val->id); ?>)" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Kamar</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('Data Kamar');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_lampiran">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Harga</th>
                    <th>Kapasitas Tamu</th>
                    <th>Tentang</th>
                    <th>Luas (m<sup>2</sup>)</th>
                    <th>Fasilitas</th>
                    <th>Tipe Bed</th>
                    <th>Total Tersedia</th>
                    <th>Tanggal Tersedia</th>
                    <th>Foto</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $kamar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($val->nama); ?></td>
                    <td><?php echo e(number_format($val->harga)); ?></td>
                    <td><?php echo e($val->kapasitas_tamu); ?> Orang</td>
                    <td><?php echo $val->about; ?></td>
                    <td><?php echo e($val->sqm); ?></td>
                    <td><?php echo $val->fasilitas; ?></td>
                    <td><?php echo $val->tipe_bed; ?></td>
                    <td><?php echo e($val->jumlah_tersedia); ?></td>
                    <td><?php echo e($val->tanggal_tersedia_awal); ?> s.d <?php echo e($val->tanggal_tersedia_akhir); ?></td>
                    <td><a href="javascript:;" class="text-primary" data-toggle="modal" data-target="#modal-tambah" onclick="upload_foto_kamar(<?php echo e($val->id); ?>);" title="Upload Foto"><i class="fas fa-upload"></i></a></td>
                    <td>
                        <a href="javascript:;" class="text-success" data-toggle="modal" data-target="#modal-tambah" onclick="edit_kamar(<?php echo e($val->id); ?>)" title="Edit"><i class="fas fa-pencil-alt"></i></a>
                        <a href="<?php echo e(url('admin/hotel/detail_kamar/'.$val->id)); ?>" class="text-primary" title="Detail"><i class="fas fa-eye"></i></a>
                        <a href="javascript:;" class="text-danger" onclick="hapus_kamar(<?php echo e($val->id); ?>)" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div id="modalContent" class="form-group">
                
            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/bundles/summernote/summernote-bs4.js')); ?>"></script>

<script>
    $("#tbl_jenis_list").DataTable();
    $("#tbl_jenis_lampiran").DataTable();
    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?php echo e(url('admin/kelurahan/tambah')); ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function GetModalContent(type)
    {
        $("#modalContent").empty();
        $("#formModal").text(type);
        $.get("<?php echo e(url('admin/hotel/get_modal_field')); ?>/" + type + "?id_hotel=<?php echo e($id); ?>", function(result){
            $("#modalContent").html(result);
            $(".summernote").summernote();
        });
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "<?php echo e(url('/admin/hotel/hapus_gambar')); ?>/"+id;
            }
        });
    }

    function edit_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Edit Kamar");
        $.get("<?php echo e(url('admin/hotel/edit_kamar')); ?>/" + id, function(result){
            $("#modalContent").html(result);
            $(".summernote").summernote();
        });
    }

    function hapus_kamar(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "<?php echo e(url('/admin/hotel/hapus_kamar')); ?>/"+id;
            }
        });
    }

    function upload_foto_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Upload Foto Kamar");
        $.get("<?php echo e(url('admin/hotel/get_modal_foto_kamar')); ?>/" + id, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/hotel/tambah.blade.php ENDPATH**/ ?>