

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Profile</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Profile</a></div>
    </div>
</div>

<?php if($errors->any()): ?>
<div class="alert alert-danger">
    <ul>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>

<div class="row mt-sm-4">
    <div class="col-12 col-md-12 col-lg-4">
      <div class="card author-box">
        <div class="card-body">
          <div class="author-box-center">
            <figure class="avatar mr-2 avatar-xl bg-warning text-white" data-initial="<?php echo e(Auth::user()->initials); ?>"></figure>
            <div class="clearfix"></div>
            <div class="author-box-name" style="margin-top: 25px">
              <a href="javascript:;"><?php echo e(Auth::user()->name); ?></a>
            </div>
            <div class="author-box-job"><?php echo e(Auth::user()->email); ?></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-12 col-lg-8">
      <div class="card">
        <div class="padding-20">
          <ul class="nav nav-tabs" id="myTab2" role="tablist">
            
            <li class="nav-item">
              <a class="nav-link active" id="profile-tab2" data-toggle="tab" href="#settings" role="tab"
                aria-selected="false">Profile</a>
            </li>
          </ul>
          <div class="tab-content tab-bordered" id="myTab3Content">
            
            <div class="tab-pane fade show active" id="settings" role="tabpanel" aria-labelledby="profile-tab2">
              <form method="post" action="<?php echo e(url('admin/profile/update')); ?>" class="needs-validation" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card-header">
                  <h4>Edit Profile</h4>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="nik">NIK</label>
                        <input id="nik" type="text" class="form-control" name="nik" value="<?php echo e(Auth::user()->nik); ?>" required>
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="name">Nama Lengkap dan Gelar</label>
                        <input id="name" type="text" class="form-control" name="name" value="<?php echo e(Auth::user()->name); ?>" autofocus required>
                    </div>
                  </div>
                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="tanggal_lahir">Tanggal Lahir</label>
                        <input id="tanggal_lahir" type="text" class="form-control datepicker" value="<?php echo e(Auth::user()->tanggal_lahir); ?>" name="tanggal_lahir" readonly required>
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="jenis_kelamin">Jenis Kelamin</label>
                        <select name="jenis_kelamin" id="jenis_kelamin" class="form-control" required>
                            <option value="">-- Pilih Jenis Kelamin --</option>
                            <option value="Laki-Laki" <?php echo e(Auth::user()->jenis_kelamin == "Laki-Laki" ? "selected" : ""); ?>>Laki-Laki</option>
                            <option value="Perempuan" <?php echo e(Auth::user()->jenis_kelamin == "Perempuan" ? "selected" : ""); ?>>Perempuan</option>
                        </select>
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="id_provinsi">Provinsi</label>
                        <select name="id_provinsi" id="id_provinsi" class="form-control" onchange="getKabKota()" required>
                            <option value="">-- Pilih Provinsi--</option>
                            <?php $__currentLoopData = $provinsi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>" <?php echo e(Auth::user()->id_provinsi == $item->id ? "selected" : ""); ?>><?php echo e($item->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="id_kabupaten">Kabupaten/Kota</label>
                        <select name="id_kabupaten" id="id_kabupaten" class="form-control" required>
                            <option value="">-- Pilih Kabupaten/Kota--</option>
                            <?php $__currentLoopData = $kabupaten; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>" <?php echo e(Auth::user()->id_kabupaten == $item->id ? "selected" : ""); ?>><?php echo e($item->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-12 col-12">
                        <label for="Alamat">Email</label>
                        <input id="email" type="text" class="form-control" name="email" required value="<?php echo e(Auth::user()->email); ?>">
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-12 col-12">
                        <label for="Alamat">Alamat</label>
                        <textarea name="alamat" id="alamat" class="form-control" required><?php echo e(Auth::user()->alamat); ?></textarea>
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="no_telp">No Telp</label>
                        <input id="no_telp" type="text" class="form-control" name="no_telp" required value="<?php echo e(Auth::user()->no_telp); ?>">
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="file_pendukung">File Pendukung (KTP/SIM)</label>
                        <input type="file" name="file_pendukung" id="file_pendukung" class="form-control">
                    </div>
                  </div>

                  
                </div>
                <div class="card-footer text-right">
                  <button class="btn btn-primary">Save Changes</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    // $("#tblData").DataTable({
    //     processing: true,
    //     serverSide: true,
    //     ajax: "<?php echo e(url('admin/ujian/get-data')); ?>",
    //     "columns": [
    //         { data: 'DT_RowIndex', name: 'DT_RowIndex' },   
    //         { data: 'program.nama', name: 'program.nama' },
    //         { data: 'tanggal', name: 'tanggal' },
    //         { data: 'pukul', name: 'pukul' },
    //         { data: 'duration', name: 'duration' },
    //         { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
    //     ]
    // });

    function getKabKota()
    {
        var id_provinsi = $("#id_provinsi").val();
        $("#id_kabupaten").empty();

        var option = "";
        $.get("<?php echo e(url('get-kab-kota')); ?>/" + id_provinsi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.name+'</option>';

            });

            $("#id_kabupaten").html(option);

        });
    }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/user/profile.blade.php ENDPATH**/ ?>