<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title><?php echo e(config('app.name')); ?></title>
        <link href="<?php echo e(asset('front/css/styles.css')); ?>" rel="stylesheet" />
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('front/assets/img/favicon.png')); ?>" />
        <script data-search-pseudo-elements defer src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/js/all.min.js" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.24.1/feather.min.js" crossorigin="anonymous"></script>
    </head>
    <body>
        <div id="layoutDefault">
            <div id="layoutDefault_content">
                <main>
                    <nav class="navbar navbar-marketing navbar-expand-lg bg-white navbar-light">
                        <div class="container">
                            <img alt="image" src="<?php echo e(asset('assets/img/logo.png')); ?>" class="header-logo" />
                            &nbsp;&nbsp;&nbsp;
                            <a class="navbar-brand text-dark" href="<?php echo e(url('/')); ?>">
                                <?php echo e(config('app.name')); ?></a>
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><i data-feather="menu"></i></button>
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav ml-auto mr-lg-5">
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/tentang')); ?>">Tentang <?php echo e(config('app.name')); ?> </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/profile')); ?>">Profil </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/mekanisme_pendaftaran')); ?>">Mekanisme Pendaftaran </a></li>
                                </ul>
                                <a class="btn-warning btn rounded-pill px-4 ml-lg-4" href="<?php echo e(url('register')); ?>">DAFTAR</a>
                                <a class="btn-teal btn rounded-pill px-4 ml-lg-4" href="<?php echo e(url('dashboard')); ?>">LOGIN<i class="fas fa-arrow-right ml-1"></i></a>
                            </div>
                        </div>
                    </nav>
                    <header class="page-header page-header-dark bg-img-repeat bg-primary" style='background-image: url("front/assets/img/pattern-shapes.png")'>
                        <div class="page-header-content">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-xl-8 col-lg-10 text-center">
                                        <h1 class="page-header-title">Sarana Management Unggul</h1>
                                        <p class="page-header-text mb-5">Start DIKLAT today!</p>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="svg-border-waves text-light">
                            <svg class="wave" style="pointer-events: none" fill="currentColor" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1920 75">
                                <defs>
                                    <style>
                                        .a {
                                            fill: none;
                                        }
                                        .b {
                                            clip-path: url(#a);
                                        }
                                        .d {
                                            opacity: 0.5;
                                            isolation: isolate;
                                        }
                                    </style>
                                    <clippath id="a"><rect class="a" width="1920" height="75"></rect></clippath>
                                </defs>
                                <title>wave</title>
                                <g class="b"><path class="c" d="M1963,327H-105V65A2647.49,2647.49,0,0,1,431,19c217.7,3.5,239.6,30.8,470,36,297.3,6.7,367.5-36.2,642-28a2511.41,2511.41,0,0,1,420,48"></path></g>
                                <g class="b"><path class="d" d="M-127,404H1963V44c-140.1-28-343.3-46.7-566,22-75.5,23.3-118.5,45.9-162,64-48.6,20.2-404.7,128-784,0C355.2,97.7,341.6,78.3,235,50,86.6,10.6-41.8,6.9-127,10"></path></g>
                                <g class="b"><path class="d" d="M1979,462-155,446V106C251.8,20.2,576.6,15.9,805,30c167.4,10.3,322.3,32.9,680,56,207,13.4,378,20.3,494,24"></path></g>
                                <g class="b"><path class="d" d="M1998,484H-243V100c445.8,26.8,794.2-4.1,1035-39,141-20.4,231.1-40.1,378-45,349.6-11.6,636.7,73.8,828,150"></path></g>
                            </svg>
                        </div>
                    </header>
                    <section class="bg-light py-10">
                        <div class="container">
                            
                            <div class="row justify-content-center">
                                <div class="col-lg-6">
                                    <div class="mb-5 text-center">
                                        <div class="text-xs text-uppercase-expanded text-primary mb-2">New DIKLAT</div>
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <?php $__currentLoopData = $program; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4" style="margin-bottom: 25px">
                                    <a class="card card-link border-top border-top-lg border-primary lift text-center o-visible h-100" href="<?php echo e(url('dashboard')); ?>">
                                        
                                        <div class="card-body text-center py-3">
                                            <div class="icon-stack icon-stack-xl bg-primary-soft text-teal mb-4 mt-n5 z-1 shadow">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-layout"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line><line x1="9" y1="21" x2="9" y2="9"></line></svg>
                                            </div>
                                            <h6 class="card-title mb-0"><?php echo e($item->nama); ?></h6>
                                            
                                            <div class="small">Oleh : <?php echo e($item->pengajar->nama ?? "-"); ?></div>
                                        </div>
                                        <div class="card-footer text-center text-xs">
                                            <svg class="svg-inline--fa fa-store-alt fa-w-20 mr-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="store-alt" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512" data-fa-i2svg="">
                                                <path fill="currentColor" d="M320 384H128V224H64v256c0 17.7 14.3 32 32 32h256c17.7 0 32-14.3 32-32V224h-64v160zm314.6-241.8l-85.3-128c-6-8.9-16-14.2-26.7-14.2H117.4c-10.7 0-20.7 5.3-26.6 14.2l-85.3 128c-14.2 21.3 1 49.8 26.6 49.8H608c25.5 0 40.7-28.5 26.6-49.8zM512 496c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V224h-64v272z"></path>
                                            </svg><!-- <i class="fas fa-store-alt mr-1"></i> -->Jadwal <?php echo e(date('d-M-Y', strtotime($item->mulai)). " s.d " .date('d-M-Y', strtotime($item->mulai))); ?>

                                        </div>
                                        
                                    </a>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    </section>
                    <hr class="my-0" />

                    <section class="bg-gradient-primary-to-secondary py-10">
                        <div class="container">
                            <div class="row text-center justify-content-center">
                                <div class="col-lg-8">
                                    <h2 class="display-4 text-white font-weight-500">Get the app!</h2>
                                    <p class="lead text-white-50 mb-5">Buy and sell items from your device with our new mobile app!</p>
                                    <div class="mb-5 mb-lg-0">
                                        <a class="mr-3" href="javascript:void(0);"><img src="<?php echo e(asset('front/assets/img/app-store-badge.svg')); ?>" style="height: 3rem;"/></a><a href="javascript:void(0);"><img src="<?php echo e(asset('front/assets/img/google-play-badge.svg')); ?>" style="height: 3rem;"/></a>
                                        <div class="page-header-text mt-2 text-xs font-italic text-white-50">* Requires Android OS 4.3+ or Apple iOS 9.3+</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="svg-border-rounded text-light">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 144.54 17.34" preserveAspectRatio="none" fill="currentColor"><path d="M144.54,17.34H0V0H144.54ZM0,0S32.36,17.34,72.27,17.34,144.54,0,144.54,0"></path></svg>
                        </div>
                    </section>
                </main>
            </div>
            <div id="layoutDefault_footer">
                <footer class="footer pt-10 pb-5 mt-auto bg-light footer-light">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="footer-brand">DIKLAT</div>
                                <div class="mb-3">Build better websites</div>
                                <div class="icon-list-social mb-5">
                                    <a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-instagram"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-facebook"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-github"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-twitter"></i></a>
                                </div>
                            </div>
                            <div class="col-lg-9">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6 mb-5 mb-lg-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Product</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Landing</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Pages</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Sections</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Documentation</a></li>
                                            <li><a href="javascript:void(0);">Changelog</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6 mb-5 mb-lg-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Technical</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Documentation</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Changelog</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Theme Customizer</a></li>
                                            <li><a href="javascript:void(0);">UI Kit</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6 mb-5 mb-md-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Includes</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Utilities</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Components</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Layouts</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Code Samples</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Products</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Affiliates</a></li>
                                            <li><a href="javascript:void(0);">Updates</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="text-uppercase-expanded text-xs mb-4">Legal</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Privacy Policy</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Terms and Conditions</a></li>
                                            <li><a href="javascript:void(0);">License</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="my-5" />
                        <div class="row align-items-center">
                            <div class="col-md-6 small">Copyright &copy; 2021</div>
                            <div class="col-md-6 text-md-right small">
                                <a href="javascript:void(0);">Privacy Policy</a>
                                &middot;
                                <a href="javascript:void(0);">Terms &amp; Conditions</a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.4.1.min.js" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="<?php echo e(asset('front/js/scripts.js')); ?>"></script>
    </body>
</html>
<?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/landing.blade.php ENDPATH**/ ?>