<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Ajukan HAKI</a></div>
    </div>
</div>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form method="POST" action="<?php echo e(url('ajukan-haki/simpan')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="id" value="0">
    <div class="card card-primary">
        
        <div class="card-body">

            <div class="form-group">
                <label class="text-dark">Nomor Surat Pengajuan <i class="text-success">*Optional</i></label>
                <input type="text" name="no_surat_pengajuan" class="form-control">
            </div>

            <div class="form-group">
                <label class="text-dark">Unggah Surat Pengajuan <i class="text-success">*(opsional | format: PDF/DOC/DOCX | maksimal 10 MB)</i></label>
                <input type="file" name="file_surat_pengajuan" class="form-control">
            </div>

            <div class="form-group">
                <label class="text-dark">Jenis Kekayaan Intelektual (KI) yang Diajukan</label>
                <select name="id_jenis_haki" id="id_jenis_haki" class="form-control" required onchange="getFormbyJenisHaki()">
                    <option value="">-- Silakan Pilih --</option>
                    <?php $__currentLoopData = $jenis_haki; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($val->id); ?>"><?php echo e($val->nama); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <i class="fa fa-spinner fa-spin" id="loadingSpin"></i>
            <div id="divJenisHaki"></div>

            <div class="form-group">
                <label class="text-dark">Satuan Kerja - Pengusul <i class="text-danger">*(wajib diisi)</i></label>
                <select name="id_satuan_kerja" class="form-control" required>
                    <option value="0">-- Silakan Pilih --</option>
                    <?php $__currentLoopData = $satuan_kerja; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($val->id); ?>"><?php echo e($val->nama); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group">
                <label class="text-dark">Judul Kekayaan Intelektual (KI) <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="judul_kekayaan_intelektual" class="form-control" required></textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Abstrak / Penjelasan Singkat KI <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="abstrak_kekayaan_intelektual" class="form-control" required></textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Nomor Kontak / HP <i class="text-danger">*(wajib diisi)</i></label>
                <input type="text" name="telp" class="form-control" required>
            </div>

            <div class="form-group">
                <label class="text-dark">Alamat Email yang Dapat Dihubungi <i class="text-danger">*(wajib diisi)</i></label>
                <input type="email" name="email" class="form-control" required>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
            <h4>Unggah File Deskripsi KI <i class="text-danger">*(wajib dilampirkan | format: PDF/DOC/DOCX | maksimal 10 MB)</i></h4><br>
            
        </div>
        <div class="card-body">
            <div id="file-container">
                <!-- Item pertama -->
                <div class="form-group file-item">
                    <div class="row align-items-center">
                        <div class="col-md-4">
                            <input type="text"
                                   name="judul_file_pendukung[]"
                                   class="form-control"
                                   placeholder="Judul File (Wajib diisi)"
                                   required>
                        </div>

                        <div class="col-md-4">
                            <input type="file"
                                   name="file_pendukung[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx"
                                   required>
                            <small class="text-muted file-preview"></small>
                        </div>

                        <div class="col-md-2 text-danger file-error"></div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file">
                    <i class="fa fa-plus"></i> Tambah File Lain
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Internal <i class="text-danger">*(wajib diisi)</i></h4>
        </div>
        <div class="card-body">
            <div id="file-container-internal">
                <!-- Item pertama -->
                <div class="form-group file-item-internal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="nama_kolabolator_internal[]" class="form-control file-input" required>
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="instansi_kolabolator_internal[]" class="form-control file-input" required>
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_ktp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   required>
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_npwp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   required>
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-internal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-internal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Eksternal <i class="text-success">*(Jika ada)</i></h4>
        </div>
        <div class="card-body">
            <div id="file-container-eksternal">
                <!-- Item pertama -->
                <div class="form-group file-item-eksternal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama</label>
                            <input type="text" name="nama_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi</label>
                            <input type="text" name="instansi_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP</label>
                            <input type="file"
                                   name="file_ktp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP</label>
                            <input type="file"
                                   name="file_npwp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-eksternal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-eksternal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    

    <div class="card card-primary">
        <div class="card-body text-center">
            <a href="<?php echo e(url('ajukan-haki')); ?>" class="btn btn-warning text-white btn-lg">KEMBALI</a>
            <button type="submit" class="btn btn-success btn-lg">SIMPAN</button>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ajukan_haki.js')); ?>"></script>
<script>
function getFormbyJenisHaki()
{
    $("#divJenisHaki").empty();
    var id_jenis_haki = $("#id_jenis_haki").val();
    $("#loadingSpin").hide();
    if(id_jenis_haki != 0)
    {
        $("#loadingSpin").show();
        $.get("<?php echo e(url('get-form-by-jenis-haki')); ?>/" + id_jenis_haki + "/0", function(response) {
            $("#divJenisHaki").empty();
            $("#divJenisHaki").html(response);
            $("#loadingSpin").hide();
        });
    }
}
getFormbyJenisHaki();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vhmfvgew/public_html/sapatriapps/resources/views/pengajuan_haki/tambah.blade.php ENDPATH**/ ?>