

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/dropzonejs/dropzone.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail Kamar</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail Kamar</h4>

    <div class="card-header-action">
        <a href="<?php echo e(url('admin/hotel/edit/'.$kamar->id_hotel)); ?>" class="btn btn-secondary">
          Kembali
        </a>
    </div>
  </div>
  <div class="card-body">
    <table class="table" width="100%">
        <tr>
            <td width="20%">Nama Kamar</td>
            <td>: <?php echo e($kamar->nama); ?></td>
        </tr>
        <tr>
            <td width="20%">Harga (per malam)</td>
            <td>: <?php echo e(number_format($kamar->harga)); ?></td>
        </tr>
        <tr>
            <td width="20%">Kapasitas Tamu</td>
            <td>: <?php echo e($kamar->kapasitas_tamu); ?> Orang</td>
        </tr>
        <tr>
            <td width="20%">Luas (m<sup>2</sup>)</td>
            <td>: <?php echo e($kamar->sqm); ?></td>
        </tr>
        <tr>
            <td width="20%">Kapasitas Ruangan Tersedia</td>
            <td>: <?php echo e($kamar->jumlah_tersedia); ?></td>
        </tr>
        <tr>
            <td width="20%">Tanggal Tersedia</td>
            <td>: <?php echo e($kamar->tanggal_tersedia_awal); ?> s.d <?php echo e($kamar->tanggal_tersedia_akhir); ?></td>
        </tr>
        <tr>
            <td width="20%">Status</td>
            <td>: <?php echo e(($kamar->is_aktif == 1 ? 'Aktif' : 'Tidak Aktif' )); ?></td>
        </tr>
        <tr>
            <td width="20%">Fasilitas</td>
            <td>: <?php echo $kamar->fasilitas; ?></td>
        </tr>
        <tr>
            <td width="20%">Tipe Bed</td>
            <td>: <?php echo $kamar->tipe_bed; ?></td>
        </tr>
        <tr>
            <td width="20%">Tentang</td>
            <td>: <?php echo $kamar->about; ?></td>
        </tr>
    </table>
  </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Foto Kamar</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="upload_foto_kamar(<?php echo e($kamar->id); ?>);">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Gambar</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $foto_kamar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($val->nama); ?></td>
                    <td><a href="<?php echo e(asset('gambar_kamar/'.$val->id_room.'/'.$val->foto)); ?>"> <img src="<?php echo e(asset('gambar_kamar/'.$val->id_room.'/'.$val->foto)); ?>" width="150" height="100"> </a></td>
                    <td>
                        <a href="javascript:;" class="text-danger" onclick="hapus(<?php echo e($val->id); ?>)" title="Hapus"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div id="modalContent" class="form-group">
                
            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script>
    $("#tbl_jenis_list").DataTable();

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "<?php echo e(url('/admin/hotel/hapus_foto_kamar')); ?>/"+id;
            }
        });
    }

    function upload_foto_kamar(id)
    {
        $("#modalContent").empty();
        $("#formModal").text("Upload Foto Kamar");
        $.get("<?php echo e(url('admin/hotel/get_modal_foto_kamar')); ?>/" + id, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/hotel/detail_kamar.blade.php ENDPATH**/ ?>