

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Pembayaran</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('/admin/pembayaran')); ?>">Pembayaran</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail</a></div>
    </div>
</div>

<div class="card">
  <div class="card-header">
    <strong>Informasi : </strong>
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-2">
        No Transaksi
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->no_transaksi); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        NIK
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->nik ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Nama Lengkap
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->name ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Tanggal Lahir
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->tanggal_lahir ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Email
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->email ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        No Telp
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->no_telp ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Alamat
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->alamat ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Provinsi
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->provinsi->name ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Kabupaten
      </div>
      <div class="col-md-10">
        : <?php echo e($pembayaran->pendaftaran_program->user->kabupaten->name ?? "N/A"); ?>

      </div>
    </div>
    <div class="row">
      <div class="col-md-2">
        Status Pembayaran
      </div>
      <div class="col-md-10">
        <?php if($pembayaran->status == "Telah Dibayar"): ?>
            <span>: <?php echo e($pembayaran->status); ?></span>
        <?php else: ?>
          <?php if($pembayaran->payment_status == null): ?>
          <span>: <?php echo e($pembayaran->status); ?></span>
          <?php else: ?>
          <span>: <?php echo e($pembayaran->payment_status); ?></span>
          <?php endif; ?>
        <?php endif; ?>
        
      </div>
    </div>
    
  </div>
</div>
<div class="row">
  <div class="col-md-12">

    <div class="card">
      <div class="card-header">
        Order Program Summary :
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-striped table-hover table-md">
            <tr>
              <th data-width="40">#</th>
              <th>Program</th>
              <th class="text-center">Jadwal</th>
              <th class="text-center">Lokasi</th>
              <th class="text-right">Harga</th>
            </tr>
            <tr>
              <td>1</td>
              <td><?php echo e($program->nama); ?></td>
              <td class="text-center"><?php echo e(date('d-M-Y', strtotime($program->mulai)). " s.d ". date('d-M-Y', strtotime($program->selesai))); ?></td>
              <td class="text-center"><?php echo e($program->nama); ?></td>
              <td class="text-right"><?php echo e(number_format($program->harga,2)); ?></td>
            </tr>
          </table>
        </div>
        <div class="row mt-4">
          <div class="col-lg-8">
            
          </div>
          <div class="col-lg-4 text-right">              
            <hr class="mt-2 mb-2">
            <div class="invoice-detail-item">
              <h5>Total Pembayaran</h5>
              <h5>Rp. <?php echo e(number_format($pembayaran->total_bayar,2)); ?></h5>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    
  </div>
</div>

<div class="invoice">
    <div class="text-md-right">
      <?php if($pembayaran->payment_status == null && $pembayaran->status != "Telah Dibayar"): ?>
      <a href="<?php echo e(url('admin/payment/checkout/'.$pembayaran->id)); ?>" class="btn btn-success btn-icon icon-left text-white"><i class="fas fa-credit-card"></i> Konfirmasi Pembayaran</a>
      <?php endif; ?>        
        <a href="<?php echo e(url('admin/pembayaran')); ?>" class="btn btn-secondary btn-icon icon-left"> Kembali</a>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Status Pembayaran</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/pembayaran/ubah_status')); ?>" method="post" id="frm_menu" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">                    
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Verifikasi Status Pembayaran</label> 
                                <select name="status" class="form-control" id="status"  required onchange="CekStatus()">
                                    <option value="">-- Pilih Status --</option>
                                    <option value="Belum Dibayar">Belum Dibayar</option>
                                    <option value="Telah Dibayar">Telah Dibayar</option>                                
                                </select> 
                            </div> 
                            <input type="hidden" name="id_pembayaran" id="id_pembayaran">
                        </div>
                    </div>

                    <div id="divTelahDibayar" style="display: none">
                        <div class="row"> 
                            <div class="col-md-12"> 
                                <div class="form-group"> 
                                    <label class="control-label">Tanggal Pembayaran</label> 
                                    <input type="text" class="form-control datepicker" readonly name="tanggal_pembayaran" id="tanggal_pembayaran">
                                </div> 
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-md-12"> 
                                <div class="form-group"> 
                                    <label class="control-label">Bukti Pembayaran</label> 
                                    <input type="file" class="form-control" name="bukti_pembayaran" id="bukti_pembayaran" accept="image/*">
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/pembayaran/detail.blade.php ENDPATH**/ ?>