<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title><?php echo e(config('app.name')); ?></title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/app.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/bundles/prism/prism.css')); ?>">
  <!-- Template CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/components.css')); ?>">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">
  <link rel='shortcut icon' type='image/x-icon' href="<?php echo e(asset('assets/img/favicon.ico')); ?>" />

  <?php echo $__env->yieldContent('css'); ?>
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <div class="navbar-bg"></div>
      <nav class="navbar navbar-expand-lg main-navbar">
        <div class="form-inline mr-auto">
          <ul class="navbar-nav mr-3">
            <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn"><i
                  class="fas fa-bars"></i></a></li>
            <li><a href="#" class="nav-link nav-link-lg fullscreen-btn">
                <i class="fas fa-expand"></i>
              </a>
            </li>
          </ul>
        </div>
        <ul class="navbar-nav navbar-right">
          <li class="dropdown"><a href="#" data-toggle="dropdown"
              class="nav-link dropdown-toggle nav-link-lg nav-link-user">
              
              <figure class="avatar mr-2 avatar-sm bg-warning text-white" data-initial="<?php echo e(Auth::user()->initials); ?>"></figure>
              <span class="d-sm-none d-lg-inline-block"></span></a>
            <div class="dropdown-menu dropdown-menu-right">
              <div class="dropdown-title">Hello <?php echo e(Auth::user()->name); ?></div>
                <a href="<?php echo e(url('/admin/profile')); ?>" class="dropdown-item has-icon">
                  <i class="far fa-user"></i> Profile
                </a>
              
              <div class="dropdown-divider"></div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                <a href="#" onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item has-icon text-danger">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
                </form>
            </div>
          </li>
        </ul>
      </nav>
      <div class="main-sidebar sidebar-style-2">
        <aside id="sidebar-wrapper">
          <div class="sidebar-brand">
            <a href="<?php echo e(url('dashboard')); ?>">
              <img alt="image" src="<?php echo e(asset('assets/img/logo.png')); ?>" class="header-logo" />
              <span class="logo-name"><?php echo e(config('app.name')); ?></span>
            </a>
          </div>
          <ul class="sidebar-menu">
            <li class="menu-header">Main</li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/dashboard')); ?>"><i class="fas fa-home"></i><span>Dashboard</span></a>
            </li>

            <?php if(Auth::user()->id_hak_akses == 1): ?>
                            

              <li class="menu-header">Program & Pembayaran</li>

              <li>
                <a class="nav-link" href="<?php echo e(url('/admin/program')); ?>"><i class="fas fa-clipboard-list"></i><span>Program</span></a>
              </li>
              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/pendaftaran_program')); ?>"><i class="fas fa-registered"></i><span>Pendaftaran Program</span></a>
              </li>
              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/pembayaran')); ?>"><i class="fas fa-money-bill-wave"></i><span>Pembayaran</span></a>
              </li>

              <li class="menu-header">Module & Ujian</li>

              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/modul')); ?>"><i class="fas fa-file-alt"></i><span>Modul & Materi</span></a>
              </li>
              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/pengajaran')); ?>"><i class="fas fa-video"></i><span>Pengajaran</span></a>
              </li>
              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/ujian')); ?>"><i class="fas fa-user-edit"></i><span>Ujian</span></a>
              </li>
              <li>
                  <a class="nav-link" href="<?php echo e(url('/admin/sertifikat')); ?>"><i class="fas fa-medal"></i><span>Sertifikat</span></a>
              </li>   

              <li class="menu-header">Admin</li>   

              <li>
                <a class="nav-link" href="<?php echo e(url('/admin/management-user')); ?>"><i class="fas fa-users"></i><span>Akun</span></a>
              </li>
                 
              <li class="dropdown">
                <a href="blank.html#" class="nav-link has-dropdown"><i class="fas fa-database"></i><span>Master Data</span></a>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="<?php echo e(url('/admin/kuisioner_ujian')); ?>">Kuisioner Ujian</a></li>
                </ul>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="<?php echo e(url('/admin/pengajar')); ?>">Pengajar</a></li>
                </ul>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="<?php echo e(url('/admin/provinsi')); ?>">Provinsi</a></li>
                </ul>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="<?php echo e(url('/admin/kabupaten')); ?>">Kab/Kota</a></li>
                </ul>
              </li>   
              
              <li class="dropdown">
                <a href="blank.html#" class="nav-link has-dropdown"><i class="fas fa-wrench"></i><span>Pengaturan</span></a>
                <ul class="dropdown-menu">
                  
                  <li><a class="nav-link" href="<?php echo e(url('/admin/konfigurasi')); ?>">Konfigurasi</a></li>
                  
                </ul>
              </li>

            <?php elseif(Auth::user()->id_hak_akses == 2): ?>
            <li class="menu-header">Program & Pembayaran</li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/program/program_saya')); ?>"><i class="fas fa-clipboard-list"></i><span>Program Saya</span></a>
            </li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/pembayaran')); ?>"><i class="fas fa-money-bill-wave"></i><span>Pembayaran</span></a>
            </li>
            <li class="menu-header">Modul & Ujian</li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/modul')); ?>"><i class="fas fa-file-alt"></i><span>Modul & Materi</span></a>
            </li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/pengajaran_saya')); ?>"><i class="fas fa-video"></i><span>Pengajaran</span></a>
            </li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/ujian')); ?>"><i class="fas fa-user-edit"></i><span>Ujian</span></a>
            </li>
            <li>
              <a class="nav-link" href="<?php echo e(url('/admin/sertifikat/sertifikat_saya')); ?>"><i class="fas fa-medal"></i><span>Sertifikat Saya</span></a>
            </li>  
            <?php endif; ?>
           
          </ul>
        </aside>
      </div>
      <!-- Main Content -->
      
      <div class="main-content">
        <section class="section">
          <div class="section-body">
            <?php echo $__env->yieldContent('isi'); ?>
          </div>
        </section>  
        <?php echo $__env->yieldContent('modal'); ?>      
      </div>
      <footer class="main-footer">
        <div class="footer-left">
          Copyright &copy; <?php echo e(date('Y')); ?> <div class="bullet"></div> Design By <a href="<?php echo e(url('dashboard')); ?>">Dani Kurniawan</a>
        </div>
        <div class="footer-right">
        </div>
      </footer>
    </div>
  </div>
  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>

  <script src="<?php echo e(asset('assets/bundles/sweetalert/sweetalert.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/bundles/prism/prism.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/bundles/jquery-ui/jquery-ui.min.js')); ?>"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->

  <script>
    $(window).on('load', function () {
        <?php if(Session::has('pesan')): ?>
        swal({
            title: "<?php echo e(Session::get('pesan.header')); ?>",
            text: "<?php echo e(Session::get('pesan.message')); ?>",
            icon: "<?php echo e(Session::get('pesan.alert-type')); ?>",
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Ok',
        });           
        
        <?php endif; ?>
    });
  </script>

  <?php echo $__env->yieldContent('js'); ?>

  <script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
  <!-- Custom JS File -->
  <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>

  
</body>

</html><?php /**PATH D:\xampp_736\htdocs\SMUDESA\resources\views/layout/template.blade.php ENDPATH**/ ?>