<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Variabel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item active"><a href="#">Variabel</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Variabel</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <!-- <div class="alert alert-info">
        <b>Penting</b> : <br> Total Persentase harus 100%
    </div> -->
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th hidden>ID</th>
                <!-- <th>Aspek</th> -->
                <th>Variabel</th>
                <!-- <th>Persentase</th> -->
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Variabel</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        
                        
                        <div class="col-md-12" id="divInfoDimensi" style="display: none">

                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Variabel</label>
                                <input type="text" class="form-control" name="name" id="name" required>
                                <input type="hidden" name="id" id="id">
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">

                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('admin/variabel/get-data')); ?>",
        "columns": [
            { data: 'id', name: 'id', visible: false },
            // { data: 'aspek', name: 'aspek' },
            { data: 'nama', name: 'nama' },
            // { data: 'persentase', name: 'persentase' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/variabel')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#name").val(data.nama);
                $("#persentase").val(data.persentase);
                // $("#id_dimensi").val(data.id_dimensi).trigger("change");
                $("#id_aspek").val(data.id_aspek).trigger("change");
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
        $("#persentase").val("");
        // $("#id_dimensi").val("").trigger("change");
        $("#id_aspek").val("").trigger("change");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/variabel')); ?>/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?php echo e(url('admin/variabel/tambah')); ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function get_info_dimensi()
    {
        var id_dimensi = $("#id_dimensi").val();
        if(id_dimensi.length != 0)
        {
            var url = "<?php echo e(url('admin/variabel/get_info_dimensi')); ?>/"+id_dimensi;
            $("#divInfoDimensi").empty();
            $("#divInfoDimensi").show();
            $.ajax({
                url: url,
                type: "GET",
                success: function(data){
                    var html = '<div class="alert alert-secondary text-dark">\
                                    Persentase : '+data.persentase+'% <br>\
                                    Total Saat Ini : '+data.total_saat_ini+'%\
                                </div>';

                    $("#divInfoDimensi").html(html);
                },
                error: function(data){
                    alert('Hubungi Admin !');
                    $("#divInfoDimensi").hide();
                }
            });
        }
        else
        {
            $("#divInfoDimensi").hide();
        }
    }
    function get_info_aspek()
    {
        var id_aspek = $("#id_aspek").val();
        if(id_aspek.length != 0)
        {
            var url = "<?php echo e(url('admin/variabel/get_info_aspek')); ?>/"+id_aspek;
            $("#divInfoDimensi").empty();
            $("#divInfoDimensi").show();
            $.ajax({
                url: url,
                type: "GET",
                success: function(data){
                    var html = '<div class="alert alert-secondary text-dark">\
                                    Persentase : '+data.persentase+'% <br>\
                                    Total Saat Ini : '+data.total_saat_ini+'%\
                                </div>';

                    $("#divInfoDimensi").html(html);
                },
                error: function(data){
                    alert('Hubungi Admin !');
                    $("#divInfoDimensi").hide();
                }
            });
        }
        else
        {
            $("#divInfoDimensi").hide();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/variabel/index.blade.php ENDPATH**/ ?>