

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Tambah Layanan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('admin/master/layanan')); ?>">Layanan</a></div>
      <div class="breadcrumb-item active"><a href="#">Tambah Layanan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-body">
    <form action="<?php echo e(url('admin/master/layanan/simpan_update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Provinsi</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="<?php echo e($provinsi->name); ?>" readonly>
            </div>
        </div>
        <?php if($id_kabupaten != null): ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Kabupaten</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" value="<?php echo e($kabupaten->name); ?>" readonly>
            </div>
        </div>        
        <?php endif; ?>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Tingkatan</label>
            <div class="col-sm-9">
                <?php if($id == 0): ?>
                <input type="text" class="form-control" name="tingkatan" value="<?php echo e($type == 'prov' ? 'Provinsi' : 'Kabupaten'); ?>" readonly>
                <?php else: ?>
                <input type="text" class="form-control" name="tingkatan" value="<?php echo e($layanan->tingkatan); ?>" readonly>
                <?php endif; ?>
                
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Nama Layanan</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="nama" name="nama" placeholder="Nama" value="<?php echo e($id == 0 ? '' : $layanan->nama); ?>" required>
                <input type="hidden" class="form-control" id="id" name="id" value="<?php echo e($id); ?>">
                <input type="hidden" class="form-control" id="id_provinsi" name="id_provinsi" value="<?php echo e(($id == 0 ? $id_provinsi : $layanan->id_provinsi)); ?>">
                <input type="hidden" class="form-control" id="id_kabupaten" name="id_kabupaten" value="<?php echo e(($id == 0 ? $id_kabupaten : $layanan->id_kabupaten)); ?>">
                <input type="hidden" class="form-control" id="type" name="type" value="<?php echo e($type); ?>">
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Gambar</label>
            <div class="col-sm-9">

                <?php if($id == 0): ?>
                <input type="file" class="form-control" id="image" name="image" required>
                <?php else: ?>
                <input type="file" class="form-control" id="image" name="image">
                <img src="<?php echo e(asset('layanan/'. $layanan->image)); ?>" height="150" width="150">
                <?php endif; ?>
            </div>
        </div>
        <div class="form-group row">
            <label for="lokasi_pengambilan" class="col-sm-3 col-form-label">Lokasi Pengambilan</label>
            <div class="col-sm-3">
                <select class="form-control" name="lokasi_pengambilan" id="lokasi_pengambilan" required>
                    <option value="Online" <?php echo e(($id == 0 ? '' : ($layanan->lokasi_pengambilan == 'Online' ? 'selected' : '' ))); ?>>Online</option>
                    <option value="Offline" <?php echo e(($id == 0 ? '' : ($layanan->lokasi_pengambilan == 'Offline' ? 'selected' : '' ))); ?>>Offline</option>
                </select>
            </div>
        </div>

        <div class="form-group row">
            <label for="status" class="col-sm-3 col-form-label">Status</label>
            <div class="col-sm-3">
                <select class="form-control" name="status" id="status" required>
                    <option value="1" <?php echo e(($id == 0 ? '' : ($layanan->is_aktif == 1 ? 'selected' : '' ))); ?>>Aktif</option>
                    <option value="0" <?php echo e(($id == 0 ? '' : ($layanan->is_aktif == 0 ? 'selected' : '' ))); ?>>Tidak Aktif</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label for="nama" class="col-sm-3 col-form-label">Keterangan</label>
            <div class="col-sm-9">
                <textarea class="form-control" name="keterangan"><?php echo e(($id == 0 ? "" : $layanan->keterangan )); ?></textarea>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-sm-12 text-right">
                <a href="<?php echo e(url('admin/master/layanan/index_detail?id_provinsi='.$id_provinsi.'&id_kabupaten='.$id_kabupaten.'&type='.$type)); ?>" class="btn btn-light">Kembali</a>
                <?php if($id == 0): ?>
                    <button type="submit" class="btn btn-success">Simpan dan Lanjut</button>
                <?php else: ?>
                    <button type="submit" class="btn btn-success">Update</button>
                <?php endif; ?>

            </div>
        </div>
    </form>
  </div>
</div>

<?php if($id != 0): ?>
<div class="card card-primary">
    <div class="card-header">
        <h4>Jenis List</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('LIST');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_list">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Tipe</th>
                    <th>Wajib Isi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $layanan_field; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($val->nama); ?></td>
                    <td><?php echo e($val->tipe); ?></td>
                    <td><?php echo e(($val->is_required == 1 ? "Ya": "Tidak")); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Jenis Lampiran</h4>
        <div class="card-header-action">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="GetModalContent('LAMPIRAN');">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
            </button>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered" id="tbl_jenis_lampiran">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Jenis Lampiran</th>
                    <th>Wajib Isi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $layanan_field_lampiran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($val->nama); ?></td>
                    <td><?php echo e($val->jenis_file); ?></td>
                    <td><?php echo e(($val->is_required == 1 ? "Ya": "Tidak")); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="<?php echo e(url('admin/master/layanan/simpan_detail')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id_layanan" value="<?php echo e($id); ?>">
                <div class="modal-body" id="modalContent">

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')); ?>"></script>
<script>
    $("#tbl_jenis_list").DataTable();
    $("#tbl_jenis_lampiran").DataTable();
    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?php echo e(url('admin/kelurahan/tambah')); ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function GetModalContent(type)
    {
        $("#modalContent").empty();
        $("#formModal").text(type);
        $.get("<?php echo e(url('admin/master/layanan/get_modal_field')); ?>/" + type, function(result){
            $("#modalContent").html(result);
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/master_layanan/tambah.blade.php ENDPATH**/ ?>