

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Kuisioner Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('/admin/kuisioner_ujian')); ?>">Kuisioner Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Setting Ujian</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Program : <?php echo e($program->nama); ?></h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" onclick="bersih()" data-target="#modal-tambah">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah Pertanyaan
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Pertanyaan</th>
                <th>Skor</th>
                <th>Jawaban Benar</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                <?php
                  $no = 1;
                  $skor = [];
                ?>
                <?php $__currentLoopData = $soal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $jawaban = \DB::table('jawabans')->where('id_soal', $item->id)->where('jawaban_benar', 1)->first();
                        $skor[] = $item->skor;
                    ?>
                    <tr>
                        <td><?php echo e($no); ?></td>
                        <td><?php echo e($item->soal); ?></td>
                        <td><?php echo e($item->skor); ?></td>
                        <td>
                            <?php echo e($jawaban->jawaban ?? ""); ?>

                        </td>
                        <td>
                            <a href="javascript:;" data-toggle="modal" data-target="#modal-tambah" onclick="edit_materi(<?php echo e($item->id); ?>)" class="btn btn-primary text-white" title="Edit">Edit</a>
                            <a href="javascript:;" onclick="hapus_materi(<?php echo e($item->id); ?>)" class="btn btn-danger text-white" title=Hapus">Hapus</a>
                        </td>
                    </tr>

                    <?php
                        $no++;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
        <br>
        <h5>Total Skor : <?php echo e(array_sum($skor)); ?> </h5>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Pertanyaan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/kuisioner_ujian/tambah_soal')); ?>" method="post" id="frm_menu" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Pertanyaan</label> 
                                <input type="text" class="form-control" name="soal" id="soal" required> 
                                <input type="hidden" class="form-control" name="id_soal" id="id_soal"> 
                                <input type="hidden" class="form-control" name="id_program" id="id_program" value="<?php echo e($id_program); ?>"> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Skor</label> 
                                <input type="number" class="form-control" name="skor" id="skor" required>
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">File</label> 
                                <input type="file" class="form-control" name="file" id="file">
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Jawaban Benar</label> 
                                <select name="jawaban_benar" id="jawaban_benar" class="form-control" required>
                                    <option value="0">A</option>
                                    <option value="1">B</option>
                                    <option value="2">C</option>
                                    <option value="3">D</option>
                                    <option value="4">E</option>
                                </select>
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Pilihan Jawaban</label>                                 
                            </div> 
                        </div>

                        <div class="col-md-1"> 
                            <div class="form-group"> 
                                <label class="control-label">A :</label>                                 
                            </div> 
                        </div>
                        <div class="col-md-11"> 
                            <div class="form-group"> 
                                <input type="text" name="pilihan_jawaban0" id="pilihan_jawaban0" class="form-control">
                            </div> 
                        </div>

                        <div class="col-md-1"> 
                            <div class="form-group"> 
                                <label class="control-label">B :</label>                                 
                            </div> 
                        </div>
                        <div class="col-md-11"> 
                            <div class="form-group"> 
                                <input type="text" name="pilihan_jawaban1" id="pilihan_jawaban1" class="form-control" required>
                            </div> 
                        </div>

                        <div class="col-md-1"> 
                            <div class="form-group"> 
                                <label class="control-label">C :</label>                                 
                            </div> 
                        </div>
                        <div class="col-md-11"> 
                            <div class="form-group"> 
                                <input type="text" name="pilihan_jawaban2" id="pilihan_jawaban2" class="form-control" required>
                            </div> 
                        </div>

                        <div class="col-md-1"> 
                            <div class="form-group"> 
                                <label class="control-label">D :</label>                                 
                            </div> 
                        </div>
                        <div class="col-md-11"> 
                            <div class="form-group"> 
                                <input type="text" name="pilihan_jawaban3" id="pilihan_jawaban3" class="form-control" required>
                            </div> 
                        </div>

                        <div class="col-md-1"> 
                            <div class="form-group"> 
                                <label class="control-label">E :</label>                                 
                            </div> 
                        </div>
                        <div class="col-md-11"> 
                            <div class="form-group"> 
                                <input type="text" name="pilihan_jawaban4" id="pilihan_jawaban4" class="form-control" required>
                            </div> 
                        </div>
                    </div> 
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script>
    $("#tblData").DataTable();

    function edit_materi(id)
    {
        var url = "<?php echo e(url('admin/kuisioner_ujian')); ?>/"+id+"/edit_soal";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_soal").val(data.soal.id);
                $("#soal").val(data.soal.soal);
                $("#skor").val(data.soal.skor);

                $.each(data.jawaban, function(i,l){

                    if(l.jawaban_benar == 1)
                    {
                        $("#jawaban_benar").val(i);
                    }
                    $("#pilihan_jawaban"+i).val(l.jawaban);

                });                
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function hapus_materi(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/kuisioner_ujian')); ?>/"+id+"/hapus_soal",
                    success: function(data){
                        swal({
                            title: "SUKSES",
                            text: "Data Terhapus!",
                            icon: "success"
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(data){
                        swal({
                            title: "GAGAL",
                            text: "Something went wrong!",
                            icon: "error"
                        });
                    }
                })
            }
        });
    }

    function bersih()
    {
        $("#id_soal").val("");
        $("#soal").val("");
        $("#skor").val("");
        $("#jawaban_benar").val(0);
        $("#pilihan_jawaban0").val("");
        $("#pilihan_jawaban1").val("");
        $("#pilihan_jawaban2").val("");
        $("#pilihan_jawaban3").val("");
        $("#pilihan_jawaban4").val("");
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/kuisioner_ujian/index_setting_ujian.blade.php ENDPATH**/ ?>