<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Status</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Status</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Status Layanan</h4>
  </div>
  <div class="card-body">
    <ul class="nav nav-tabs" id="myTab2" role="tablist">
        <li class="nav-item">
          <a class="nav-link active" id="home-tab2" data-toggle="tab" href="#home2" role="tab" aria-controls="home" aria-selected="true">Provinsi</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="profile-tab2" data-toggle="tab" href="#profile2" role="tab" aria-controls="profile" aria-selected="false">Kabupaten</a>
        </li>
    </ul>
    <div class="tab-content tab-bordered" id="myTab3Content">
        <div class="tab-pane fade show active" id="home2" role="tabpanel" aria-labelledby="home-tab2">  
            <div class="form-group replyBox m-t-20">
        
                <div class="row">
                  <div class="col-md-6">
                    <label>Pilih Provinsi</label>
                    <select class="form-control select2" name="id_provinsi" id="id_provinsi" style="width: 100%">
                      <option value="">-- Silakan pilih --</option>
                    </select>
                  </div> 
                  <div class="col-md-6">
                    <label>Pilih Kabupaten</label>
                    <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" style="width: 100%">
                      <option value="">-- Silakan pilih --</option>
                    </select>
                  </div>  
                  
                </div>  
                <div class="row" style="margin-top: 15px">
                    <div class="col-md-12 text-right">
                        <button type="button" class="btn btn-secondary" onclick="reset_data()"> Reset </button>
                        <button type="button" class="btn btn-primary" onclick="filter_data()"> FILTER </button>
                    </div>  
                </div>             
            </div>
        
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="tblData" style="width:100%;">
                  <thead>
                    <tr>
                        <th>Provinsi</th>
                        <th>Pemda</th>
                        <th>Layanan</th>
                        <th>Nama Lengkap</th>
                        <th>No Layanan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
            </div>
        </div>
        
        <div class="tab-pane fade" id="profile2" role="tabpanel" aria-labelledby="profile-tab2">
            <div class="form-group replyBox m-t-20">
        
                <div class="row">
                  <div class="col-md-6">
                    <label>Pilih Provinsi</label>
                    <select class="form-control select2" name="id_provinsi_kab" id="id_provinsi_kab" style="width: 100%">
                      <option value="">-- Silakan pilih --</option>
                    </select>
                  </div> 
                  <div class="col-md-6">
                    <label>Pilih Kabupaten</label>
                    <select class="form-control select2" name="id_kabupaten_kab" id="id_kabupaten_kab" style="width: 100%">
                      <option value="">-- Silakan pilih --</option>
                    </select>
                  </div>  
                  
                </div>  
                <div class="row" style="margin-top: 15px">
                    <div class="col-md-12 text-right">
                        <button type="button" class="btn btn-secondary" onclick="reset_data_kab()"> Reset </button>
                        <button type="button" class="btn btn-primary" onclick="filter_data_kab()"> FILTER </button>
                    </div>  
                </div>             
            </div>
        
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="tblDataKab" style="width:100%;">
                  <thead>
                    <tr>
                        <th>Provinsi</th>
                        <th>Pemda</th>
                        <th>Layanan</th>
                        <th>Nama Lengkap</th>
                        <th>No Layanan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
            </div>
        </div>
    </div>    
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="<?php echo e(url('admin/master/layanan/simpan_detail')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body" id="modalContent">

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script>

    function generate_data(id_provinsi, id_kabupaten)
    {
        $("#tblData").DataTable({
            destroy: true,
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(url('layanans/status/get_data')); ?>?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&tab=provinsi",
            "columns": [
                { data: 'provinsi', name: 'provinsi' },
                { data: 'kabupaten', name: 'kabupaten' },
                { data: 'layanan', name: 'layanan' },
                { data: 'nama_lengkap', name: 'nama_lengkap' },
                { data: 'no_layanan', name: 'no_layanan' },
                { data: 'status', name: 'status' },
                { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
            ]
        });
    }

    function generate_data_kab(id_provinsi, id_kabupaten)
    {
        $("#tblDataKab").DataTable({
            destroy: true,
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(url('layanans/status/get_data')); ?>?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&tab=kabupaten",
            "columns": [
                { data: 'provinsi', name: 'provinsi' },
                { data: 'kabupaten', name: 'kabupaten' },
                { data: 'layanan', name: 'layanan' },
                { data: 'nama_lengkap', name: 'nama_lengkap' },
                { data: 'no_layanan', name: 'no_layanan' },
                { data: 'status', name: 'status' },
                { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
            ]
        });
    }

    generate_data("", "");
    generate_data_kab("", "");

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/kabupaten')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#province_id").val(data.province_id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
        $("#province_id").val("");
    }

    function hapus_data(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('layanans/status/hapus')); ?>/"+id,
                    success: function(data){
                        generate_data("", "");
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        generate_data("", "");
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?php echo e(url('admin/kabupaten/tambah')); ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_provinsi_kab").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten_kab").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi_kab").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

    function filter_data()
    {
        var id_provinsi = $("#id_provinsi").val();
        var id_kabupaten = $("#id_kabupaten").val();
        generate_data(id_provinsi, id_kabupaten)
    }

    function filter_data_kab()
    {
        var id_provinsi = $("#id_provinsi_kab").val();
        var id_kabupaten = $("#id_kabupaten_kab").val();
        generate_data_kab(id_provinsi, id_kabupaten)
    }

    function reset_data()
    {
        $("#id_provinsi").val("").trigger("change");
        $("#id_kabupaten").val("").trigger("change");
        filter_data()
    }

    function reset_data_kab()
    {
        $("#id_provinsi_kab").val("").trigger("change");
        $("#id_kabupaten_kab").val("").trigger("change");
        filter_data_kab()
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/layanan/status.blade.php ENDPATH**/ ?>