<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Bukti Bayar</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Bukti Bayar</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Bukti Bayar</h4>

    <div class="card-header-action">
        <a href="<?php echo e(url('bukti-bayar/tambah')); ?>" class="btn btn-primary text-white">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Kode Pengajuan</th>
                <th>File</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('bukti-bayar/get-data')); ?>",
        "columns": [
            { data: 'kode_pengajuan', name: 'kode_pengajuan' },
            { data: 'file', name: 'file' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    // function edit_data(id)
    // {
    //     var url = "<?php echo e(url('admin/pengajar')); ?>/"+id+"/edit";

    //     $.ajax({
    //         url: url,
    //         type: "GET",
    //         success: function(data){
    //             $("#id").val(data.id);
    //             $("#nama").val(data.nama);
    //             $("#email").val(data.email);
    //             $("#jenis_kelamin").val(data.jenis_kelamin);
    //             $("#no_telp").val(data.no_telp);
    //             $("#alamat").val(data.alamat);
    //         },
    //         error: function(data){
    //             alert('Hubungi Admin !');
    //         }
    //     });
    // }

    // function bersih()
    // {
    //     $("#id").val("");
    //     $("#nama").val("");
    //     $("#email").val("");
    //     $("#jenis_kelamin").val("");
    //     $("#no_telp").val("");
    //     $("#alamat").val("");
    // }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('bukti-bayar')); ?>/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    // $("#frm_data").on("submit", function(e){
    //     e.preventDefault();
    //     $("#modal-tambah").modal('hide');
    //     $.ajax({
    //         type:"POST",
    //         url: "<?php echo e(url('admin/pengajar/tambah')); ?>",
    //         data: $(this).serialize(),
    //         success: function(result){
    //             table_data.ajax.reload();

    //             if(result.issuccess)
    //                 swal("Sukses", result.message, "success");
    //             else
    //                 swal("Gagal", result.message, "error");
    //         }
    //     })
    // });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vhmfvgew/public_html/sapatriapps/resources/views/bukti_bayar/index.blade.php ENDPATH**/ ?>