

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="<?php echo e(url('/admin/ujian')); ?>">Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Open</a></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
      <h4>Memulai Ujian</h4>
    </div>
    <div class="card-body">
        <div class="row">
            <label class="col-md-2">Nama Program</label>
            <div class="col-md-10">: <?php echo e($ujian->program->nama ?? "N/A"); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Tanggal Ujian</label>
            <div class="col-md-10">: <?php echo e(date('d-M-Y', strtotime($ujian->tanggal))); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Pukul</label>
            <div class="col-md-10">: <?php echo e(date('H:i', strtotime($ujian->jam_mulai)). " s.d ". date('H:i', strtotime($ujian->jam_selesai))); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Durasi</label>
            <div class="col-md-10">: <?php echo e(SMUDESA::GetDurasi($ujian->tanggal,$ujian->jam_mulai,$ujian->jam_selesai)); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Skor Syarat Kelulusan</label>
            <div class="col-md-10">: <?php echo e($ujian->syarat_kelulusan); ?></div>
        </div>

        <?php if(
                date('Y-m-d H:i') >= date('Y-m-d H:i', strtotime($ujian->tanggal." ".$ujian->jam_mulai))
                &&
                date('Y-m-d H:i') <= date('Y-m-d H:i', strtotime($ujian->tanggal." ".$ujian->jam_selesai))
            ): ?>

            <div class="empty-state">
                <form id="fromMulaiUjian" method="POST" action="<?php echo e(url('admin/ujian/start')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="<?php echo e($ujian->id); ?>" name="id_ujian">
                    <input type="hidden" value="<?php echo e($ujian->id_program); ?>" name="id_program">
                    <button type="button" onclick="StartUjian()" class="btn btn-success mt-4 btn-lg text-white">MULAI</button>
                </form>       
            </div>
        <?php else: ?>
            <div class="empty-state">       
                <button type="button" class="btn btn-success mt-4 btn-lg text-white" disabled>MULAI</button>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>

    function StartUjian()
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan memulai ujian!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $("#fromMulaiUjian").submit();
            }
        });
    }
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/ujian/open.blade.php ENDPATH**/ ?>