<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Program</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Program</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Program</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Harga (Rp)</th>
                <th>Ketua Pengajar</th>
                <th>Kuota</th>
                <th>Kuota Tersedia</th>
                <th>Jadwal</th>
                <th>Lokasi</th>
                <th>Status</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Program</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/program/tambah')); ?>" method="post" id="frm_menu">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Nama Program</label>
                                <input type="text" class="form-control" name="nama" id="nama" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Ketua Pengajar</label>
                                <select name="id_pengajar" class="form-control" id="id_pengajar"  required>
                                    <option value="">-- Pilih Ketuan Pengajar --</option>
                                    <?php $__currentLoopData = $pengajar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->nama); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="hidden" name="id_program" id="id_program">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Harga (Rp)</label>
                                <input type="number" class="form-control" name="harga" id="harga" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Kuota</label>
                                <input type="number" class="form-control" name="kuota" id="kuota" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Skor Minimal Kelulusan</label>
                                <input type="number" class="form-control" name="skor_kelulusan" id="skor_kelulusan" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jadwal Mulai</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </div>
                                    </div>
                                    <input type="text" data-date-format="yyyy-mm-dd" class="form-control datepicker" name="mulai" id="mulai" readonly required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jadwal Selesai</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </div>
                                    </div>
                                    <input type="text" data-date-format="yyyy-mm-dd" class="form-control datepicker" name="selesai" id="selesai" readonly required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Tipe Program</label>
                                <select name="tipe_program" class="form-control" id="tipe_program"  required>
                                    <option value="">-- Pilih Tipe Program --</option>
                                    <option value="Online">Online</option>
                                    <option value="Tatap Muka Langsung">Tatap Muka Langsung</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Lokasi</label>
                                <textarea name="lokasi" id="lokasi" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Tambah Pembayaran</label>
                                <select name="is_pembayaran" class="form-control" id="is_pembayaran"  required>
                                    <option value="">-- Pilih --</option>
                                    <option value="1">Ya</option>
                                    <option value="0">Tidak</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Status</label>
                                <select name="status" class="form-control" id="status"  required>
                                    <option value="">-- Pilih Status --</option>
                                    <option value="Draft">Draft</option>
                                    <option value="Aktif">Aktif</option>
                                    <option value="Selesai">Selesai</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('admin/program/get-data')); ?>",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'nama', name: 'nama' },
            { data: 'harga', name: 'harga' },
            { data: 'nama_pengajar', name: 'nama_pengajar' },
            { data: 'kuota', name: 'kuota' },
            { data: 'kuota_tersedia', name: 'kuota_tersedia' },
            { data: 'jadwal', name: 'jadwal' },
            { data: 'lokasi', name: 'lokasi' },
            { data: 'status', name: 'status' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/program')); ?>/"+id+"/edit";
        $("#id_induk").val("0");
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_program").val(data.id);
                $("#nama").val(data.nama);
                $("#id_pengajar").val(data.id_pengajar);
                $("#harga").val(data.harga);
                $("#kuota").val(data.kuota);
                $("#mulai").val(data.mulai);
                $("#selesai").val(data.selesai);
                $("#tipe_program").val(data.tipe_program);
                $("#lokasi").val(data.lokasi);
                $("#status").val(data.status);
                $("#skor_kelulusan").val(data.skor_kelulusan);
                $("#is_pembayaran").val(data.is_pembayaran);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_program").val("");
        $("#nama").val("");
        $("#id_pengajar").val("");
        $("#harga").val("");
        $("#kuota").val("");
        $("#mulai").val("");
        $("#selesai").val("");
        $("#tipe_program").val("");
        $("#lokasi").val("");
        $("#status").val("");
        $("#skor_kelulusan").val("");
        $("#is_pembayaran").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus Program ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/program')); ?>/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\SMUDESA\resources\views/program/index.blade.php ENDPATH**/ ?>