
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<style>
.hidden{
    visibility: collapse;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Dashboard</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-primary">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::TIDAK_MISKIN); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-success">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::RENTAN_MISKIN); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-warning">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::HAMPIR_MISKIN); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon l-bg-yellow">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::MISKIN); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-danger">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::SANGAT_MISKIN); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-secondary">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted"><?php echo e(SMUDESA::BELUM_INPUT_DATA); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="row">
    <div class="col-md-12">
        <div class="card">
            
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab2" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab2" data-toggle="tab" href="#home2" role="tab" aria-controls="home" aria-selected="true">Detail</a>
                    </li>
                    
                </ul>
                <div class="tab-content tab-bordered" id="myTab3Content">
                    <div class="tab-pane fade show active" id="home2" role="tabpanel" aria-labelledby="home-tab2">
                        <div class="form-group replyBox m-t-20">
        
                            <div class="row">
                              <div class="col-md-4">
                                <label>Pilih Provinsi</label>
                                <select class="form-control select2" name="id_provinsi" id="id_provinsi" style="width: 100%">
                                  <option value="">-- Silakan pilih --</option>
                                </select>
                              </div> 
                              <div class="col-md-4">
                                <label>Pilih Kabupaten</label>
                                <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" style="width: 100%">
                                  <option value="">-- Silakan pilih --</option>
                                </select>
                              </div>  
                              <div class="col-md-4">
                                <label>Status</label>
                                <select class="form-control" name="status" id="status" style="width: 100%">
                                  <option value="0">Semua</option>
                                  <option value="<?php echo e(SMUDESA::TIDAK_MISKIN); ?>"><?php echo e(SMUDESA::TIDAK_MISKIN); ?></option>
                                  <option value="<?php echo e(SMUDESA::RENTAN_MISKIN); ?>"><?php echo e(SMUDESA::RENTAN_MISKIN); ?></option>
                                  <option value="<?php echo e(SMUDESA::HAMPIR_MISKIN); ?>"><?php echo e(SMUDESA::HAMPIR_MISKIN); ?></option>
                                  <option value="<?php echo e(SMUDESA::MISKIN); ?>"><?php echo e(SMUDESA::MISKIN); ?></option>
                                  <option value="<?php echo e(SMUDESA::SANGAT_MISKIN); ?>"><?php echo e(SMUDESA::SANGAT_MISKIN); ?></option>
                                  <option value="<?php echo e(SMUDESA::BELUM_INPUT_DATA); ?>"><?php echo e(SMUDESA::BELUM_INPUT_DATA); ?></option>
                                </select>
                              </div> 
                            </div>  
                            <div class="row" style="margin-top: 15px">
                                <div class="col-md-12 text-right">
                                    <button type="button" class="btn btn-secondary" onclick="reset_data()"> Reset </button>
                                    <button type="button" class="btn btn-primary" onclick="filter_data()"> FILTER </button>
                                </div>  
                            </div>             
                        </div>
                    
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="tblData" style="width:100%;">
                              <thead>
                                <tr>
                                    <th>Provinsi</th>
                                    <th>Kabupaten</th>
                                    
                                    <th>Kode</th>
                                    <th>NIK</th>
                                    <th>No KK</th>
                                    <th>Nama Lengkap</th>
                                    <th>Skor</th>
                                    <th>Status</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                        </div>
                    </div>
                    
                </div>
            </div>
          </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>

<script>
    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

    function filter_data()
    {
        var id_provinsi = $("#id_provinsi").val();
        var id_kabupaten = $("#id_kabupaten").val();
        var status = $("#status").val();
        generate_data(id_provinsi, id_kabupaten, status)
    }

    function reset_data()
    {
        $("#id_provinsi").val("").trigger("change");
        $("#id_kabupaten").val("").trigger("change");
        $("#status").val("0").trigger("change");
        filter_data()
    }

    function generate_data(id_provinsi, id_kabupaten, status)
    {
        $("#tblData").DataTable({
            destroy: true,
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(url('dukcapil/get-data')); ?>?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&status="+status,
            "columns": [
                { data: 'provinsi', name: 'provinsi' },
                { data: 'kabupaten', name: 'kabupaten' },
                // { data: 'kecamatan.name', name: 'kecamatan.name' },
                { data: 'code', name: 'code' },
                { data: 'nik', name: 'nik' },
                { data: 'no_kk', name: 'no_kk' },
                { data: 'nama_lengkap', name: 'nama_lengkap' },
                { data: 'skor', name: 'skor' },
                { data: 'status', name: 'status' },
                // { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
            ]
        });
    }

    generate_data("", "", 0);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/dashboard/index.blade.php ENDPATH**/ ?>