

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Modul & Materi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Modul & Materi</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header" style="display: block">
    <h4>Program : <?php echo e($program->nama); ?></h4>
    <h4>Materi : <?php echo e($materi->nama); ?></h4>
    
    <div class="card-header-action pull-right">
        <a href="<?php echo e(url('admin/modul/lihat_materi/'.$materi->id)); ?>" class="btn btn-warning text-white"> Kembali</a>
        <?php if(Auth::user()->id_hak_akses != 2): ?>
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah Modul
        </button>
        <?php endif; ?>
    </div>
    
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Modul</th>
                <th>Deskripsi</th>
                <th>File</th>
                <?php if(Auth::user()->id_hak_akses != 2): ?>
                <th>Aksi</th>
                <?php endif; ?>
            </tr>
          </thead>
          <tbody>
                <?php
                  $no = 1;
                ?>
                <?php $__currentLoopData = $modul; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($no); ?></td>
                        <td><?php echo e($item->nama); ?></td>
                        <td><?php echo e($item->deskripsi); ?></td>
                        <td>
                            <?php if($item->tipe == "File"): ?>
                                <a href="<?php echo e(url('/admin/modul/download/'.$item->id)); ?>" class="btn btn-success text-white" title="Edit">Download</a>
                            <?php elseif($item->tipe == "Link"): ?>
                                <a href="<?php echo e($item->link); ?>" target="_blank" title="Link">Go To Link</a>
                            <?php else: ?>
                                <span>N/A</span>
                            <?php endif; ?>
                        </td>
                        <?php if(Auth::user()->id_hak_akses != 2): ?>
                        <td>
                            <a href="javascript:;" data-toggle="modal" data-target="#modal-tambah" onclick="edit_modul(<?php echo e($item->id); ?>)" class="btn btn-primary text-white" title="Edit">Edit</a>
                            <a href="javascript:;" onclick="hapus_modul(<?php echo e($item->id); ?>)" class="btn btn-danger text-white" title=Hapus">Hapus</a>
                        </td>
                        <?php endif; ?>
                    </tr>

                    <?php
                        $no++;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Modul</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/modul/tambah')); ?>" method="post" id="frm_menu" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama Modul</label> 
                                <input type="text" class="form-control" name="nama" id="nama" required maxlength="255"> 
                                <input type="hidden" class="form-control" name="id_modul" id="id_modul"> 
                                <input type="hidden" class="form-control" name="id_materi" id="id_materi" value="<?php echo e($materi->id); ?>"> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Tipe</label> 
                                <select class="form-control" name="tipe" id="tipe" required onchange="cekTipe()">
                                    <option value="">-- Pilih Tipe --</option>
                                    <option value="File">File</option>
                                    <option value="Link">Link</option>
                                </select>
                            </div> 
                        </div>
                    </div> 
                    <div class="row" id="divTipeLink" style="display: none"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Link</label> 
                                <input type="text" name="link" id="link" class="form-control">
                            </div> 
                        </div>
                    </div>
                    <div class="row" id="divTipeFile" style="display: none"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">File</label> 
                                <input type="file" name="file" id="file" class="form-control">
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Deskripsi</label> 
                                <textarea name="deskripsi" class="form-control" id="deskripsi"></textarea>
                            </div> 
                        </div>
                    </div> 
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script>
    $("#tblData").DataTable();

    function edit_materi(id)
    {
        var url = "<?php echo e(url('admin/modul/materi')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_materi").val(data.id);
                $("#nama").val(data.nama);
                $("#deskripsi").val(data.deskripsi);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function hapus_materi(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/modul/hapus_materi')); ?>/"+id,
                    success: function(data){
                        swal({
                            title: "SUKSES",
                            text: "Data Terhapus!",
                            icon: "success"
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(data){
                        swal({
                            title: "GAGAL",
                            text: "Something went wrong!",
                            icon: "error"
                        });
                    }
                })
            }
        });
    }

    function edit_modul(id)
    {
        var url = "<?php echo e(url('admin/modul')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_modul").val(data.id);
                $("#nama").val(data.nama);
                $("#deskripsi").val(data.deskripsi);
                $("#tipe").val(data.tipe);
                $("#link").val(data.link);

                cekTipe();
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function hapus_modul(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/modul/hapus')); ?>/"+id,
                    success: function(data){
                        swal({
                            title: "SUKSES",
                            text: "Data Terhapus!",
                            icon: "success"
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(data){
                        swal({
                            title: "GAGAL",
                            text: "Something went wrong!",
                            icon: "error"
                        });
                    }
                })
            }
        });
    }

    function cekTipe()
    {
        var tipe = $("#tipe").val();

        if(tipe == "Link")
        {
            $("#divTipeLink").show();
            $("#divTipeFile").hide();
        }
        else if(tipe == "File")
        {
            $("#divTipeLink").hide();
            $("#divTipeFile").show();
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\SMUDESA\resources\views/modul/index_modul.blade.php ENDPATH**/ ?>