<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Pembayaran</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Pembayaran</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Pembayaran</h4>

    
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>No Pendaftaran</th>
                <th>No Transaksi</th>
                <th>Program</th>
                <th>Harga (Rp)</th>
                <th>Nama</th>
                <th>Kab/Kota</th>
                <th>No Telp</th>
                <th>Jadwal</th>
                <th>Status</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Status Pembayaran</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/pembayaran/ubah_status')); ?>" method="post" id="frm_menu" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Verifikasi Status Pembayaran</label>
                                <select name="status" class="form-control" id="status"  required onchange="CekStatus()">
                                    <option value="">-- Pilih Status --</option>
                                    <option value="Belum Dibayar">Belum Dibayar</option>
                                    <option value="Telah Dibayar">Telah Dibayar</option>
                                </select>
                            </div>
                            <input type="hidden" name="id_pembayaran" id="id_pembayaran">
                        </div>
                    </div>

                    <div id="divTelahDibayar" style="display: none">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label">Tanggal Pembayaran</label>
                                    <input type="text" class="form-control datepicker" readonly name="tanggal_pembayaran" id="tanggal_pembayaran">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label">Bukti Pembayaran</label>
                                    <input type="file" class="form-control" name="bukti_pembayaran" id="bukti_pembayaran" accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('admin/pembayaran/get-data')); ?>",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'no_pendaftaran', name: 'no_pendaftaran' },
            { data: 'no_transaksi', name: 'no_transaksi' },
            { data: 'nama_program', name: 'nama_program' },
            { data: 'harga_program', name: 'harga_program' },
            { data: 'nama_peserta', name: 'nama_peserta' },
            { data: 'kabupaten', name: 'kabupaten' },
            { data: 'no_telp_peserta', name: 'no_telp_peserta' },
            { data: 'jadwal', name: 'jadwal' },
            { data: 'status', name: 'status' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/pembayaran')); ?>/"+id+"/edit_status";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_pembayaran").val(data.id);
                $("#tanggal_pembayaran").val(data.tanggal_pembayaran);
                $("#status").val(data.status);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function CekStatus()
    {
        var status = $("#status").val();

        if(status == "Telah Dibayar")
        {
            $("#divTelahDibayar").show();
        }
        else
        {
            $("#divTelahDibayar").hide();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\SMUDESA\resources\views/pembayaran/index.blade.php ENDPATH**/ ?>