<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Status</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Status</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Status</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>NIK</th>
                <th>Layanan</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="<?php echo e(url('admin/master/layanan/simpan_detail')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body" id="modalContent">

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('layanans/status/get_data')); ?>",
        "columns": [
            { data: 'user.nik', name: 'user.nik' },
            { data: 'layanan.nama', name: 'layanan.nama' },
            { data: 'status', name: 'status' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/kabupaten')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#province_id").val(data.province_id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
        $("#province_id").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/kabupaten')); ?>/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?php echo e(url('admin/kabupaten/tambah')); ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/layanan/status.blade.php ENDPATH**/ ?>