

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Profile</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Profile</a></div>
    </div>
</div>

<?php if($errors->any()): ?>
<div class="alert alert-danger">
    <ul>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>

<div class="row mt-sm-4">
    <div class="col-12 col-md-12 col-lg-4">
      <div class="card author-box">
        <div class="card-body">
          <div class="author-box-center">
            <figure class="avatar mr-2 avatar-xl bg-warning text-white" data-initial="<?php echo e(Auth::user()->initials); ?>"></figure>
            <div class="clearfix"></div>
            <div class="author-box-name" style="margin-top: 25px">
              <a href="javascript:;"><?php echo e(Auth::user()->name); ?></a>
            </div>
            <div class="author-box-job"><?php echo e(Auth::user()->email); ?></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-12 col-lg-8">
      <div class="card">
        <div class="padding-20">
          <ul class="nav nav-tabs" id="myTab2" role="tablist">
            
            <li class="nav-item">
              <a class="nav-link active" id="profile-tab2" data-toggle="tab" href="#settings" role="tab"
                aria-selected="false">Profile</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" id="profile-tab3" data-toggle="tab" href="#ubah_password" role="tab"
                aria-selected="false">Ubah Password</a>
            </li>
          </ul>
          <div class="tab-content tab-bordered" id="myTab3Content">
            <div class="tab-pane fade show active" id="settings" role="tabpanel" aria-labelledby="profile-tab2">
              <form method="post" action="<?php echo e(url('dukcapil/simpan')); ?>" class="needs-validation" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card-header">
                  <h4>Edit Profile</h4>
                </div>
                <div class="card-body">
                    <input type="hidden" name="id" value="<?php echo e($dukcapil->id); ?>">
                    <input type="hidden" name="sumber_dari" value="profile">
                    <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>NIK</label>
                              <input type="text" name="nik" class="form-control" value="<?php echo e($dukcapil->nik); ?>" required>
                          </div>
                          <div class="col-md-6">
                              <label>No KK</label>
                              <input type="text" name="no_kk" class="form-control" value="<?php echo e($dukcapil->no_kk); ?>" required>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Nama Lengkap</label>
                              <input type="text" name="nama_lengkap" class="form-control" value="<?php echo e($dukcapil->nama_lengkap); ?>" required>
                          </div>
                          <div class="col-md-6">
                              <label>Jenis Kelamin</label>
                              <select name="jenis_kelamin" class="form-control" required>
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="Laki-Laki" <?php echo e(($dukcapil->jenis_kelamin == "Laki-Laki" ? "selected" : "")); ?>>Laki-Laki</option>
                                  <option value="Perempuan" <?php echo e(($dukcapil->jenis_kelamin == "Perempuan" ? "selected" : "")); ?>>Perempuan</option>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Tempat Lahir</label>
                              <input type="text" name="tempat_lahir" class="form-control" value="<?php echo e($dukcapil->tempat_lahir); ?>" required>
                          </div>
                          <div class="col-md-6">
                              <label>Tanggal Lahir</label>
                              <input type="date" name="tanggal_lahir" class="form-control" value="<?php echo e($dukcapil->tanggal_lahir); ?>" required>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Agama</label>
                              <select name="id_agama" class="form-control" required>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php $__currentLoopData = $agama; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($val->id); ?>" <?php echo e(($dukcapil->id_agama == $val->id ? "selected" : "")); ?>><?php echo e($val->nama); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Golongan Darah</label>
                              <select name="golongan_darah" class="form-control">
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="A" <?php echo e(($dukcapil->golongan_darah == "A" ? "selected" : "")); ?>>A</option>
                                  <option value="B" <?php echo e(($dukcapil->golongan_darah == "B" ? "selected" : "")); ?>>B</option>
                                  <option value="AB" <?php echo e(($dukcapil->golongan_darah == "AB" ? "selected" : "")); ?>>AB</option>
                                  <option value="O" <?php echo e(($dukcapil->golongan_darah == "O" ? "selected" : "")); ?>>O</option>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-12">
                              <label>Alamat Sekarang</label>
                              <textarea name="alamat_sekarang" class="form-control" required><?php echo e($dukcapil->alamat_sekarang); ?></textarea>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Provinsi</label>
                              <select name="id_provinsi" id="id_provinsi" class="form-control select2" required>
                                  <?php if($provinsi == null): ?>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php else: ?>
                                  <option value="<?php echo e($provinsi->id); ?>"><?php echo e($provinsi->name); ?></option>
                                  <?php endif; ?>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Kabupaten/Kota</label>
                              <select name="id_kabupaten" id="id_kabupaten" class="form-control select2" required>
                                  <?php if($kabupaten == null): ?>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php else: ?>
                                  <option value="<?php echo e($kabupaten->id); ?>"><?php echo e($kabupaten->name); ?></option>
                                  <?php endif; ?>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Kecamatan</label>
                              <select name="id_kecamatan" id="id_kecamatan" class="form-control select2" required>
                                  <?php if($kecamatan == null): ?>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php else: ?>
                                  <option value="<?php echo e($kecamatan->id); ?>"><?php echo e($kecamatan->name); ?></option>
                                  <?php endif; ?>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Kelurahan</label>
                              <select name="id_kelurahan" id="id_kelurahan" class="form-control select2" required>
                                  <?php if($kelurahan == null): ?>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php else: ?>
                                  <option value="<?php echo e($kelurahan->id); ?>"><?php echo e($kelurahan->name); ?></option>
                                  <?php endif; ?>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-12">
                              <label>Alamat Sebelumnya</label>
                              <textarea name="alamat_sebelumnya" class="form-control"><?php echo e($dukcapil->alamat_sebelumnya); ?></textarea>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Status Perkawinan</label>
                              <select name="status_perkawinan" class="form-control" required>
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="Lajang" <?php echo e(($dukcapil->status_perkawinan == "Lajang" ? "selected" : "")); ?>>Lajang</option>
                                  <option value="Kawin" <?php echo e(($dukcapil->status_perkawinan == "Kawin" ? "selected" : "")); ?>>Kawin</option>
                                  <option value="Duda/Janda" <?php echo e(($dukcapil->status_perkawinan == "Duda/Janda" ? "selected" : "")); ?>>Duda/Janda</option>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Tanggal Perkawinan</label>
                              <input type="date" name="tanggal_perkawinan" value="<?php echo e($dukcapil->tanggal_perkawinan); ?>" class="form-control">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Status Hubungan Keluarga</label>
                              <input type="text" name="status_hub_keluarga" class="form-control" value="<?php echo e($dukcapil->status_hub_keluarga); ?>">
                          </div>
                          <div class="col-md-6">
                              <label>Cacat Fisik/Mental</label>
                              <input type="text" name="cacat_fisik_mental" class="form-control" value="<?php echo e($dukcapil->cacat_fisik_mental); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Pendidikan Terakhir</label>
                              <select name="id_pendidikan_terakhir" class="form-control" required>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php $__currentLoopData = $pendidikan_terakhir; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($val->id); ?>" <?php echo e(($dukcapil->id_pendidikan_terakhir == $val->id ? "selected" : "")); ?>><?php echo e($val->nama); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Jenis Pekerjaan</label>
                              <select name="id_jenis_pekerjaan" class="form-control" required>
                                  <option value="">-- Silakan Pilih --</option>
                                  <?php $__currentLoopData = $jenis_pekerjaan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($val->id); ?>" <?php echo e(($dukcapil->id_jenis_pekerjaan == $val->id ? "selected" : "")); ?>><?php echo e($val->nama); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>NIK Ibu</label>
                              <input type="text" name="nik_ibu" class="form-control" value="<?php echo e($dukcapil->nik_ibu); ?>">
                          </div>
                          <div class="col-md-6">
                              <label>Nama Ibu</label>
                              <input type="text" name="nama_ibu" class="form-control" value="<?php echo e($dukcapil->nama_ibu); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>NIK Ayah</label>
                              <input type="text" name="nik_ayah" class="form-control" value="<?php echo e($dukcapil->nik_ayah); ?>">
                          </div>
                          <div class="col-md-6">
                              <label>Nama Ayah</label>
                              <input type="text" name="nama_ayah" class="form-control" value="<?php echo e($dukcapil->nama_ibu); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Kepemilikan Akta Lahir</label>
                              <select name="kepemilikan_akta_lahir" class="form-control">
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="Ya" <?php echo e(($dukcapil->kepemilikan_akta_lahir == "Ya" ? "selected" : "")); ?>>Ya</option>
                                  <option value="Tidak" <?php echo e(($dukcapil->kepemilikan_akta_lahir == "Tidak" ? "selected" : "")); ?>>Tidak</option>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Nomor Akta Lahir</label>
                              <input type="text" name="nomor_akta_lahir" class="form-control" value="<?php echo e($dukcapil->nomor_akta_lahir); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Kepemilikan Akta Kawin</label>
                              <select name="kepemilikan_akta_kawin" class="form-control">
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="Ya" <?php echo e(($dukcapil->kepemilikan_akta_kawin == "Ya" ? "selected" : "")); ?>>Ya</option>
                                  <option value="Tidak" <?php echo e(($dukcapil->kepemilikan_akta_kawin == "Tidak" ? "selected" : "")); ?>>Tidak</option>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Nomor Akta Kawin</label>
                              <input type="text" name="nomor_akta_kawin" class="form-control" value="<?php echo e($dukcapil->nomor_akta_kawin); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-6">
                              <label>Kepemilikan Akta Cerai</label>
                              <select name="kepemilikan_akta_cerai" class="form-control">
                                  <option value="">-- Silakan Pilih --</option>
                                  <option value="Ya" <?php echo e(($dukcapil->kepemilikan_akta_cerai == "Ya" ? "selected" : "")); ?>>Ya</option>
                                  <option value="Tidak" <?php echo e(($dukcapil->kepemilikan_akta_cerai == "Tidak" ? "selected" : "")); ?>>Tidak</option>
                              </select>
                          </div>
                          <div class="col-md-6">
                              <label>Nomor Akta Cerai</label>
                              <input type="text" name="nomor_akta_cerai" class="form-control" value="<?php echo e($dukcapil->nomor_akta_cerai); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-4">
                              <label>Tanggal Cerai</label>
                              <input type="date" name="tanggal_cerai" class="form-control" value="<?php echo e($dukcapil->tanggal_cerai); ?>">
                          </div>
                          <div class="col-md-4">
                              <label>Latitude</label>
                              <input type="text" name="latitude" class="form-control" value="<?php echo e($dukcapil->latitude); ?>">
                          </div>
                          <div class="col-md-4">
                              <label>Longitude</label>
                              <input type="text" name="longitude" class="form-control" value="<?php echo e($dukcapil->longitude); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="row">
                          <div class="col-md-12">
                              <label>Gambar</label>
                              <input type="file" name="foto" class="form-control">
                              <br>
                              <img src="<?php echo e(asset('foto_dukcapil/'.$dukcapil->foto)); ?>" height="200" alt="Tidak ada foto">
                          </div>
                      </div>
                  </div>
                </div>
                <div class="card-footer text-right">
                  <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
              </form>
            </div>
            <div class="tab-pane" id="ubah_password" role="tabpanel" aria-labelledby="profile-tab3">
              <form action="<?php echo e(url('/admin/update_password')); ?>" method="POST">
                <?php echo csrf_field(); ?>
              <div class="row">
                <div class="form-group col-md-6 col-12">
                    <label for="password">Password Baru</label>
                    <input type="hidden" class="form-control" name="id_user_change" value="<?php echo e(Auth::user()->id); ?>" required>
                    <input id="password" type="password" class="form-control" name="password" required>
                </div>

                <div class="form-group col-12">
                  <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
              </div>  
              </form>           
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kecamatan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kecamatan_by_kab')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kabupaten_id: $("#id_kabupaten").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kelurahan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kelurahan_by_kecamatan')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kecamatan_id: $("#id_kecamatan").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/user/profile.blade.php ENDPATH**/ ?>