

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="<?php echo e(url('/admin/ujian')); ?>">Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Hasil Ujian</a></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
      <h4>Hasil Ujian</h4>
    </div>
    <div class="card-body">

        <div class="col-md-12 text-center">
            <?php if($peserta_ujian->status == "GAGAL"): ?>
            <h4 class="text-danger"><?php echo e($peserta_ujian->status); ?></h4>
            <?php else: ?>
            <h4 class="text-success"><?php echo e($peserta_ujian->status); ?></h4>
            <?php endif; ?>
            
        </div>
        <div class="row">
            <label class="col-md-2">Nama Program</label>
            <div class="col-md-10">: <?php echo e($ujian->program->nama ?? "N/A"); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Tanggal Ujian</label>
            <div class="col-md-10">: <?php echo e(date('d-M-Y', strtotime($ujian->tanggal))); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Pukul</label>
            <div class="col-md-10">: <?php echo e(date('H:i', strtotime($ujian->jam_mulai)). " s.d ". date('H:i', strtotime($ujian->jam_selesai))); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Durasi</label>
            <div class="col-md-10">: <?php echo e(SMUDESA::GetDurasi($ujian->tanggal,$ujian->jam_mulai,$ujian->jam_selesai)); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Skor Syarat Kelulusan</label>
            <div class="col-md-10">: <?php echo e($ujian->syarat_kelulusan); ?></div>
        </div>

        <hr>

        <div class="row">
            <label class="col-md-2">Anda Mulai</label>
            <div class="col-md-10">: <?php echo e(date('H:i', strtotime($peserta_ujian->jam_mulai)). " s.d ". date('H:i', strtotime($peserta_ujian->jam_selesai))); ?></div>
        </div>
        <div class="row">
            <label class="col-md-2">Skor Anda</label>
            <div class="col-md-10">: <b><?php echo e($peserta_ujian->skor); ?></b></div>
        </div>
        <div class="row">
            <label class="col-md-2">Status</label>
            <div class="col-md-10">: <b><?php echo e($peserta_ujian->status); ?></b></div>
        </div>
        
        <div class="empty-state"> 
            <div class="row">
                <a href="<?php echo e(url('admin/ujian')); ?>" class="btn btn-warning mt-4 text-white" style="margin-right: 5px">Kembali</a>
                <a href="<?php echo e(url('admin/ujian/lihat_jawaban/'.$peserta_ujian->id_ujian.'/'.$peserta_ujian->id_user)); ?>" class="btn btn-primary mt-4 text-white">Lihat Jawaban</a>
            </div>      
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>

    function StartUjian()
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan memulai ujian!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $("#fromMulaiUjian").submit();
            }
        });
    }
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/ujian/result.blade.php ENDPATH**/ ?>