

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Program Saya</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Program</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Program Saya</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> DAFTAR PROGRAM
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Program</th>
                <th>Harga (Rp)</th>
                <th>Ketua Pengajar</th>
                <th>Jadwal</th>
                <th>Lokasi</th>
                <th>Status</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Daftar Program</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/program/program_saya/daftar')); ?>" method="post" id="frm_menu">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Pilih Program</label> 
                                <select name="id_program" class="form-control" id="id_program" onchange="get_detail_program()"  required>
                                    <option value="">-- Pilih Program --</option>
                                    <?php $__currentLoopData = $program; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->nama); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select> 
                                <input type="hidden" name="id_pendaftaran_program" id="id_pendaftaran_program">
                            </div> 
                        </div>
                    </div>
                    <div id="iconProses" style="display: none"><i class="fa fa-spinner fa-spin"> </i> Mohon tunggu...</div>
                    <div id="divDetailProgram"></div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary" disabled id="btnSubmit">DAFTAR</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js')); ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('admin/program/get-data-program-saya')); ?>",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },                
            { data: 'program.nama', name: 'program.nama' },
            { data: 'harga', name: 'harga' },
            { data: 'nama_pengajar', name: 'nama_pengajar' },
            { data: 'jadwal', name: 'jadwal' },
            { data: 'lokasi', name: 'lokasi' },
            { data: 'status', name: 'status' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {  
        var url = "<?php echo e(url('admin/program')); ?>/"+id+"/edit";
        $("#id_induk").val("0");
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_program").val(data.id);
                $("#nama").val(data.nama);
                $("#id_pengajar").val(data.id_pengajar);
                $("#harga").val(data.harga);
                $("#kuota").val(data.kuota);
                $("#mulai").val(data.mulai);
                $("#selesai").val(data.selesai);
                $("#tipe_program").val(data.tipe_program);
                $("#lokasi").val(data.lokasi);
                $("#status").val(data.status);
                $("#skor_kelulusan").val(data.skor_kelulusan);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#divDetailProgram").empty();
        $("#iconProses").hide();
        $("#id_program").val("");
        $("#btnSubmit").attr("disabled", true);
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus Program ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/program/program_saya')); ?>/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    function get_detail_program()
    {
        var id_program = $("#id_program").val();

        $("#divDetailProgram").empty();
        $("#iconProses").show();

        $.get("<?php echo e(url('admin/program/program_saya/get_partial_detail_program')); ?>/" + id_program, function(result){
            $("#divDetailProgram").html(result);
            $("#iconProses").hide();
            $("#btnSubmit").attr("disabled", false);
        });

    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\L8\resources\views/program/index_program_saya.blade.php ENDPATH**/ ?>