<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title><?php echo e(config('app.name')); ?></title>
        <link href="<?php echo e(asset('front/css/styles.css')); ?>" rel="stylesheet" />
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('front/assets/img/favicon.png')); ?>" />
        <script data-search-pseudo-elements defer src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/js/all.min.js" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.24.1/feather.min.js" crossorigin="anonymous"></script>
    </head>
    <body>
        <div id="layoutDefault">
            <div id="layoutDefault_content">
                <main>
                    <nav class="navbar navbar-marketing navbar-expand-lg bg-white navbar-light">
                        <div class="container">
                            <img alt="image" src="<?php echo e(asset('assets/img/logo.png')); ?>" class="header-logo" />
                            &nbsp;&nbsp;&nbsp;
                            <a class="navbar-brand text-dark" href="<?php echo e(url('/')); ?>">
                                <?php echo e(config('app.name')); ?></a>
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><i data-feather="menu"></i></button>
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav ml-auto mr-lg-5">
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/tentang')); ?>">Tentang SMU DESA </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/profile')); ?>">Profil </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/mekanisme_pendaftaran')); ?>">Mekanisme Pendaftaran </a></li>
                                </ul>
                                <a class="btn-warning btn rounded-pill px-4 ml-lg-4" href="<?php echo e(url('register')); ?>">DAFTAR</a>
                                <a class="btn-teal btn rounded-pill px-4 ml-lg-4" href="<?php echo e(url('dashboard')); ?>">LOGIN<i class="fas fa-arrow-right ml-1"></i></a>
                            </div>
                        </div>
                    </nav>
                    
                    <section class="bg-white py-10">
                        <div class="container">
                            <h1><?php echo $front->profile ?? ""; ?></h1>
                            <p class="lead">You can use this page as a starting point to create your own custom pages, or choose an already built example page to start development!</p>
                            <p>Lorem ipsum dolor sit, amet consectetur adipisicing elit. Qui quisquam animi temporibus ipsum iusto necessitatibus laudantium beatae. Eligendi dolorum laudantium numquam? Officiis nemo error animi aliquam dolor consequatur ducimus unde.</p>
                            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Qui repellat magni eaque beatae explicabo fugit placeat earum, dolores quaerat aperiam vero adipisci quidem minus officiis blanditiis unde? Incidunt, ea ad.</p>
                            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Perspiciatis sed illum soluta, quaerat et deleniti magnam laudantium, non omnis numquam quos placeat. Porro autem consectetur dolor minima voluptatum modi maiores.</p>
                        </div>
                    </section>
                    <hr class="my-0" />
                    
                    <section class="bg-gradient-primary-to-secondary py-10">
                        <div class="container">
                            <div class="row text-center justify-content-center">
                                <div class="col-lg-8">
                                    <h2 class="display-4 text-white font-weight-500">Get the app!</h2>
                                    <p class="lead text-white-50 mb-5">Buy and sell items from your device with our new mobile app!</p>
                                    <div class="mb-5 mb-lg-0">
                                        <a class="mr-3" href="javascript:void(0);"><img src="<?php echo e(asset('front/assets/img/app-store-badge.svg')); ?>" style="height: 3rem;"/></a><a href="javascript:void(0);"><img src="<?php echo e(asset('front/assets/img/google-play-badge.svg')); ?>" style="height: 3rem;"/></a>
                                        <div class="page-header-text mt-2 text-xs font-italic text-white-50">* Requires Android OS 4.3+ or Apple iOS 9.3+</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="svg-border-rounded text-light">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 144.54 17.34" preserveAspectRatio="none" fill="currentColor"><path d="M144.54,17.34H0V0H144.54ZM0,0S32.36,17.34,72.27,17.34,144.54,0,144.54,0"></path></svg>
                        </div>
                    </section>
                </main>
            </div>
            <div id="layoutDefault_footer">
                <footer class="footer pt-10 pb-5 mt-auto bg-light footer-light">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="footer-brand">DIKLAT</div>
                                <div class="mb-3">Build better websites</div>
                                <div class="icon-list-social mb-5">
                                    <a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-instagram"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-facebook"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-github"></i></a><a class="icon-list-social-link" href="javascript:void(0);"><i class="fab fa-twitter"></i></a>
                                </div>
                            </div>
                            <div class="col-lg-9">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6 mb-5 mb-lg-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Product</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Landing</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Pages</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Sections</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Documentation</a></li>
                                            <li><a href="javascript:void(0);">Changelog</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6 mb-5 mb-lg-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Technical</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Documentation</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Changelog</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Theme Customizer</a></li>
                                            <li><a href="javascript:void(0);">UI Kit</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6 mb-5 mb-md-0">
                                        <div class="text-uppercase-expanded text-xs mb-4">Includes</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Utilities</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Components</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Layouts</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Code Samples</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Products</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Affiliates</a></li>
                                            <li><a href="javascript:void(0);">Updates</a></li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="text-uppercase-expanded text-xs mb-4">Legal</div>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2"><a href="javascript:void(0);">Privacy Policy</a></li>
                                            <li class="mb-2"><a href="javascript:void(0);">Terms and Conditions</a></li>
                                            <li><a href="javascript:void(0);">License</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="my-5" />
                        <div class="row align-items-center">
                            <div class="col-md-6 small">Copyright &copy; 2021</div>
                            <div class="col-md-6 text-md-right small">
                                <a href="javascript:void(0);">Privacy Policy</a>
                                &middot;
                                <a href="javascript:void(0);">Terms &amp; Conditions</a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.4.1.min.js" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="<?php echo e(asset('front/js/scripts.js')); ?>"></script>
    </body>
</html>
<?php /**PATH D:\xampp_736\htdocs\SMUDESA\resources\views/profile.blade.php ENDPATH**/ ?>