<!DOCTYPE html>
<html lang="en">
<head>
<title>Integrasi Data</title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="description" content="Travelix Project">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/bootstrap4/bootstrap.min.css')); ?>">
<link href="<?php echo e(asset('assets/travelix/plugins/font-awesome-4.7.0/css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.carousel.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.theme.default.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/animate.css')); ?>">
<link href="<?php echo e(asset('assets/travelix/plugins/colorbox/colorbox.css')); ?>" rel="stylesheet" type="text/css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/single_listing_styles.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/single_listing_responsive.css')); ?>">

</head>

<body>

<div class="super_container">
	
	<!-- Header -->

	<header class="header">

		<!-- Top Bar -->

		<div class="top_bar">
			<div class="container">
				<div class="row">
					<div class="col d-flex flex-row">
						
						<div class="user_box ml-auto">
							<div class="user_box_login user_box_link"><a href="<?php echo e(url('dashboard')); ?>">Login</a></div>
						</div>
					</div>
				</div>
			</div>		
		</div>

		<!-- Main Navigation -->

		<nav class="main_nav">
			<div class="container">
				<div class="row">
					<div class="col main_nav_col d-flex flex-row align-items-center justify-content-start">
						<div class="logo_container">
							<div class="logo"><a href="<?php echo e(url('/')); ?>">Integrasi Data</a></div>
						</div>
						<div class="main_nav_container ml-auto">
							<ul class="main_nav_list">
								<li class="main_nav_item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('front/hotel')); ?>">Hotel</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('front/wisata')); ?>">Wisata</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('dashboard')); ?>">Layanan Publik</a></li>
							</ul>
						</div>

						

						<div class="hamburger">
							<i class="fa fa-bars trans_200"></i>
						</div>
					</div>
				</div>
			</div>	
		</nav>

	</header>

	<div class="menu trans_500">
		<div class="menu_content d-flex flex-column align-items-center justify-content-center text-center">
			<div class="menu_close_container"><div class="menu_close"></div></div>
			<div class="logo menu_logo"><a href="#"><img src="images/logo.png" alt=""></a></div>
			<ul>
                <li class="menu_item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
                <li class="menu_item"><a href="<?php echo e(url('front/hotel')); ?>">Hotel</a></li>
                <li class="menu_item"><a href="<?php echo e(url('front/wisata')); ?>">Wisata</a></li>
                <li class="menu_item"><a href="<?php echo e(url('dashboard')); ?>">Layanan Publik</a></li>
			</ul>
		</div>
	</div>

	<!-- Home -->

    

    <div class="container" style="margin-top: 100px">
        <div class="row">
            <div class="col-lg-12">
                <div class="single_listing">
                    
                    <!-- Hotel Info -->

                    <div class="hotel_info">

                        <!-- Title -->
                        <div class="hotel_title_container d-flex flex-lg-row flex-column">
                            <div class="hotel_title_content">
                                <h1 class="hotel_title"><?php echo e($hotel->nama); ?></h1>
                                <div class="rating_r rating_r_4 hotel_rating">
                                    <i></i>
                                    <i></i>
                                    <i></i>
                                    <i></i>
                                    <i></i>
                                </div>
                                <div class="hotel_location"><?php echo e($hotel->alamat); ?></div>
                            </div>
                            
                        </div>

                        <!-- Listing Image -->

                        <div class="hotel_image">
                            <img src="<?php echo e(SMUDESA::get_first_foto_hotel($hotel->id)); ?>" alt="" style="width: 1110px; height: 723px">
                            <div class="hotel_review_container d-flex flex-column align-items-center justify-content-center">
                                <div class="hotel_review">
                                    <div class="hotel_review_content">
                                        <div class="hotel_review_title">very good</div>
                                        <div class="hotel_review_subtitle">100 reviews</div>
                                    </div>
                                    <div class="hotel_review_rating text-center">8.1</div>
                                </div>
                            </div>
                        </div>

                        <!-- Hotel Gallery -->

                        <div class="hotel_gallery">
                            <div class="hotel_slider_container">
                                <div class="owl-carousel owl-theme hotel_slider">

                                    <!-- Hotel Gallery Slider Item -->
                                    <?php $__currentLoopData = $hotel_foto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="owl-item">
                                        <a class="colorbox cboxElement" href="<?php echo e(asset('gambar_hotel/'.$item->id_hotel.'/'.$item->foto)); ?>">
                                            <img src="<?php echo e(asset('gambar_hotel/'.$item->id_hotel.'/'.$item->foto)); ?>" style="width: 102px; height: 101px">
                                        </a>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </div>

                                <!-- Hotel Slider Nav - Prev -->
                                <div class="hotel_slider_nav hotel_slider_prev">
                                    <svg version="1.1" id="Layer_6" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                        width="28px" height="33px" viewBox="0 0 28 33" enable-background="new 0 0 28 33" xml:space="preserve">
                                        <defs>
                                            <linearGradient id='hotel_grad_prev'>
                                                <stop offset='0%' stop-color='#fa9e1b'/>
                                                <stop offset='100%' stop-color='#8d4fff'/>
                                            </linearGradient>
                                        </defs>
                                        <path class="nav_path" fill="#F3F6F9" d="M19,0H9C4.029,0,0,4.029,0,9v15c0,4.971,4.029,9,9,9h10c4.97,0,9-4.029,9-9V9C28,4.029,23.97,0,19,0z
                                        M26,23.091C26,27.459,22.545,31,18.285,31H9.714C5.454,31,2,27.459,2,23.091V9.909C2,5.541,5.454,2,9.714,2h8.571
                                        C22.545,2,26,5.541,26,9.909V23.091z"/>
                                        <polygon class="nav_arrow" fill="#F3F6F9" points="15.044,22.222 16.377,20.888 12.374,16.885 16.377,12.882 15.044,11.55 9.708,16.885 11.04,18.219 
                                        11.042,18.219 "/>
                                    </svg>
                                </div>
                                
                                <!-- Hotel Slider Nav - Next -->
                                <div class="hotel_slider_nav hotel_slider_next">
                                    <svg version="1.1" id="Layer_7" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                    width="28px" height="33px" viewBox="0 0 28 33" enable-background="new 0 0 28 33" xml:space="preserve">
                                        <defs>
                                            <linearGradient id='hotel_grad_next'>
                                                <stop offset='0%' stop-color='#fa9e1b'/>
                                                <stop offset='100%' stop-color='#8d4fff'/>
                                            </linearGradient>
                                        </defs>
                                    <path class="nav_path" fill="#F3F6F9" d="M19,0H9C4.029,0,0,4.029,0,9v15c0,4.971,4.029,9,9,9h10c4.97,0,9-4.029,9-9V9C28,4.029,23.97,0,19,0z
                                    M26,23.091C26,27.459,22.545,31,18.285,31H9.714C5.454,31,2,27.459,2,23.091V9.909C2,5.541,5.454,2,9.714,2h8.571
                                    C22.545,2,26,5.541,26,9.909V23.091z"/>
                                    <polygon class="nav_arrow" fill="#F3F6F9" points="13.044,11.551 11.71,12.885 15.714,16.888 11.71,20.891 13.044,22.224 18.379,16.888 17.048,15.554 
                                    17.046,15.554 "/>
                                    </svg>
                                </div>

                            </div>
                        </div>

                        <!-- Hotel Info Text -->

                        <div class="hotel_info_text">
                            <h4>Tentang </h4>
                            <hr>
                            <?php echo $hotel->tentang; ?>

                        </div>

                        <div class="hotel_info_text">
                            <h4>Fasilitas </h4>
                            <hr>
                            <?php echo $hotel->fasilitas; ?>

                        </div>

                        <!-- Hotel Info Tags -->

                        

                    </div>
                    
                    <!-- Rooms -->

                    <div class="rooms">

                        <?php $__currentLoopData = $room; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Room -->
                        <div class="room">

                            <!-- Room -->
                            <div class="row">
                                <div class="col-lg-2">
                                    <div class="room_image"><img src="<?php echo e(SMUDESA::get_first_foto_kamar($items->id)); ?>" alt=""></div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="room_content">
                                        <div class="room_title"><?php echo e($items->nama); ?></div>
                                        <div class="room_price">Rp. <?php echo e(number_format($items->harga)); ?> per malam</div>
                                        
                                    </div>
                                </div>
                                <div class="col-lg-3 text-lg-right">
                                    <div class="room_button">
                                        <div class="button book_button trans_200"><a href="#">Pesan<span></span><span></span><span></span></a></div>
                                    </div>
                                </div>
                            </div>	
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                        

                    </div>

                    <!-- Reviews -->

                    <div class="reviews" style="display: none">
                        <div class="reviews_title">reviews</div>
                        <div class="reviews_container">

                            <!-- Review -->
                            <div class="review">
                                <div class="row">
                                    <div class="col-lg-1">
                                        <div class="review_image">
                                            <img src="images/review_1.jpg" alt="https://unsplash.com/@saaout">
                                        </div>
                                    </div>
                                    <div class="col-lg-11">
                                        <div class="review_content">
                                            <div class="review_title_container">
                                                <div class="review_title">"We loved the services"</div>
                                                <div class="review_rating">9.5</div>
                                            </div>
                                            <div class="review_text">
                                                <p>Tetur adipiscing elit. Nullam eu convallis tortor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus quis vulputate eros, iaculis consequat nisl. Nunc et suscipit urna. Integer elementum orci eu vehicula pretium. Donec bibendum tristique condimentum.</p>
                                            </div>
                                            <div class="review_name">Christinne Smith</div>
                                            <div class="review_date">12 November 2017</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Review -->
                            <div class="review">
                                <div class="row">
                                    <div class="col-lg-1">
                                        <div class="review_image">
                                            <img src="images/review_2.jpg" alt="Image by Andrew Robles">
                                        </div>
                                    </div>
                                    <div class="col-lg-11">
                                        <div class="review_content">
                                            <div class="review_title_container">
                                                <div class="review_title">"Nice staff and great location"</div>
                                                <div class="review_rating">9.5</div>
                                            </div>
                                            <div class="review_text">
                                                <p>Tetur adipiscing elit. Nullam eu convallis tortor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus quis vulputate eros, iaculis consequat nisl. Nunc et suscipit urna. Integer elementum orci eu vehicula pretium. Donec bibendum tristique condimentum.</p>
                                            </div>
                                            <div class="review_name">Christinne Smith</div>
                                            <div class="review_date">12 November 2017</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- Location on Map -->

                    <div class="location_on_map" style="display: none">
                        <div class="location_on_map_title">location on map</div>

                        <!-- Google Map -->
    
                        <div class="travelix_map">
                            <div id="google_map" class="google_map">
                                <div class="map_container">
                                    <div id="map"></div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

	<!-- Copyright -->

	<div class="copyright">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 order-lg-1 order-2  ">
					<div class="copyright_content d-flex flex-row align-items-center">
						<div><!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="fa fa-heart-o" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib</a>
<!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. --></div>
					</div>
				</div>
				<div class="col-lg-9 order-lg-2 order-1">
					<div class="footer_nav_container d-flex flex-row align-items-center justify-content-lg-end">
						<div class="footer_nav">
							<ul class="footer_nav_list">
								
                                <li class="footer_nav_item"><a href="#">Home</a></li>
                                <li class="footer_nav_item"><a href="#">Hotel</a></li>
                                <li class="footer_nav_item"><a href="#">Wisata</a></li>
                                <li class="footer_nav_item"><a href="#l">Layanan Publik</a></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</div>

<script src="<?php echo e(asset('assets/travelix/js/jquery-3.2.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/styles/bootstrap4/popper.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/styles/bootstrap4/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.carousel.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/easing/easing.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/parallax-js-master/parallax.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/colorbox/jquery.colorbox-min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.carousel.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/js/single_listing_custom.js')); ?>"></script>
</body>

</html><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/front_end/hotel/detail.blade.php ENDPATH**/ ?>