

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('admin/hotel')); ?>">Hotel</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Hotel</h4>

    <div class="card-header-action">
        <a href="<?php echo e(url('admin/hotel')); ?>" class="btn btn-secondary">
          Kembali
        </a>
        <a href="<?php echo e(url('admin/hotel/tambah?id_provinsi='.$id_provinsi.'&id_kabupaten='.$id_kabupaten.'&type='.$type)); ?>" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <!-- <th>Kecamatan</th> -->
                <th>Nama</th>
                <th>Provinsi</th>
                <th>Kabupaten</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $layanan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($val->nama); ?></td>
                <td><?php echo e($val->provinsi->name ?? ""); ?></td>
                <td><?php echo e($val->kabupaten->name ?? "-"); ?></td>
                <td><?php echo ($val->is_aktif == 1 ? "<span class='badge badge-success'>Aktif</span>" : "<span class='badge badge-danger'>Tidak Aktif</span>"); ?></td>
                <td>
                    <a href="<?php echo e(url('admin/hotel/edit/'. $val->id)); ?>" title="Edit" class="btn btn-primary">Edit</a>
                    <a href="#" class="btn btn-danger text-white" onclick="hapus(<?php echo e($val->id); ?>)" title="Hapus">Hapus</a>
                </td>
            </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script>
    var table_data = $("#tblData").DataTable();

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "<?php echo e(url('/admin/hotel/hapus')); ?>/"+id;
            }
        });
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/hotel/index_detail.blade.php ENDPATH**/ ?>